/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer2.ui.SimpleExoPlayerView;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.plugins.Tracking;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import org.jose4j.base64url.internal.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

class TrackingLive
implements Tracking {
    private static final String EVENT_LOAD = "lo";
    private static final String EVENT_PLAY = "pl";
    private static final String EVENT_PAUSE = "pa";
    private static final String EVENT_ONLINE = "on";
    private static final String EVENT_COMPLETE = "co";
    private static final long TASK_EVENT_ON_TIME = 60000L;
    private static final String ORIGIN_SDK_ANDROID = "player.sambatech.sdk.android";
    private SambaMediaConfig media;
    private SttmLive sttmLive;
    private Context context;
    private SambaPlayerListener playerListener = new SambaPlayerListener(){

        @Override
        public void onLoad(SambaEvent event) {
            super.onLoad(event);
            TrackingLive.this.sttmLive.trackLoadEvent();
        }

        @Override
        public void onPlay(SambaEvent event) {
            super.onPlay(event);
            if (!TrackingLive.this.sttmLive.isOnEventTaskRunning()) {
                TrackingLive.this.sttmLive.trackPlayAndONEvent();
                TrackingLive.this.sttmLive.startOnEventTask();
            }
        }

        @Override
        public void onPause(SambaEvent event) {
            super.onPause(event);
            TrackingLive.this.sttmLive.cancelOnEventTask();
            TrackingLive.this.sttmLive.trackPauseEvent();
        }

        @Override
        public void onError(SambaEvent event) {
            super.onError(event);
            TrackingLive.this.sttmLive.cancelOnEventTask();
        }
    };

    TrackingLive() {
    }

    @Override
    public void onLoad(@NonNull SambaPlayer player) {
        Log.i((String)"track", (String)"load");
        this.context = player.getContext();
        this.media = (SambaMediaConfig)player.getMedia();
        this.init();
        PluginManager.getInstance().notifyPluginLoaded(this);
    }

    @Override
    public void onInternalPlayerCreated(@NonNull SimpleExoPlayerView internalPlayer) {
    }

    @Override
    public void onDestroy() {
        Log.i((String)"track", (String)"destroy");
        SambaEventBus.unsubscribe(this.playerListener);
        if (this.sttmLive != null) {
            this.sttmLive.destroy();
            this.sttmLive = null;
        }
    }

    private void init() {
        if (this.media.sttmUrl != null && this.sttmLive == null) {
            this.sttmLive = new SttmLive();
        }
        if (this.media.projectHash != null && this.media.id != null) {
            SambaEventBus.subscribe(this.playerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sttm2 getSttm2() throws Exception {
        InputStream inputStream = null;
        Scanner scanner = null;
        try {
            URL myURL = new URL(this.getSttm2RequestUrl());
            HttpURLConnection conn = (HttpURLConnection)myURL.openConnection();
            conn.setRequestProperty("Content-Type", "text/plain");
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 299) {
                inputStream = conn.getInputStream();
                scanner = new Scanner(inputStream);
                Sttm2 sttm2 = this.getSttm2ResponseFromScanner(scanner);
                return sttm2;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (scanner != null) {
                    scanner.close();
                }
            }
            catch (IOException e) {
                Log.w((String)this.getClass().getSimpleName(), (String)"Error closing server request", (Throwable)e);
            }
        }
        return null;
    }

    private Sttm2 getSttm2ResponseFromScanner(Scanner scanner) throws Exception {
        int delimiter = this.media.id != null ? Integer.parseInt(this.media.id.split("(?=\\d[a-zA-Z]*$)")[1].substring(0, 1)) : 0;
        Scanner scannerDelimited = scanner.useDelimiter("\\A");
        if (scannerDelimited.hasNext()) {
            String token = scannerDelimited.next();
            token = token.substring(delimiter, token.length() - delimiter).replaceAll("-", "+").replaceAll("_", "/");
            switch (token.length() % 4) {
                case 0: {
                    break;
                }
                case 2: {
                    token = token + "==";
                    break;
                }
                case 3: {
                    token = token + "=";
                    break;
                }
            }
            byte[] tokenBytes = Base64.decodeBase64((String)token);
            String jsonString = new String(tokenBytes);
            JSONObject json = new JSONObject(jsonString);
            if (json.has("key")) {
                Sttm2 response = new Sttm2();
                response.key = json.getString("key");
                response.url = json.has("url") ? json.getString("url") : this.media.sttm2Url;
                return response;
            }
        }
        return null;
    }

    private String getSttm2RequestUrl() {
        String baseUrl = this.context.getString(R.string.player_endpoint_prod);
        return String.format("%s%s/jwt/%s", baseUrl, this.media.projectHash, this.media.id);
    }

    private class Sttm2 {
        public String key;
        public String url;

        private Sttm2() {
        }
    }

    private class SttmLive {
        private Timer sttm2Timer;
        private boolean isEventTimerTaskRunning;

        private SttmLive() {
        }

        public void startOnEventTask() {
            this.sttm2Timer = new Timer();
            this.sttm2Timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SttmLive.this.trackOnEvent();
                }
            }, 60000L, 60000L);
            this.isEventTimerTaskRunning = true;
        }

        public boolean isOnEventTaskRunning() {
            return this.isEventTimerTaskRunning;
        }

        public void cancelOnEventTask() {
            if (this.sttm2Timer != null) {
                this.sttm2Timer.cancel();
                this.sttm2Timer.purge();
                this.sttm2Timer = null;
                this.isEventTimerTaskRunning = false;
            }
        }

        void trackPlayEvent() {
            this.sendEvents(TrackingLive.EVENT_PLAY);
        }

        void trackPlayAndONEvent() {
            this.sendEvents(TrackingLive.EVENT_ONLINE, TrackingLive.EVENT_PLAY);
        }

        void trackPauseEvent() {
            this.sendEvents(TrackingLive.EVENT_PAUSE);
        }

        void trackLoadEvent() {
            this.sendEvents(TrackingLive.EVENT_LOAD);
        }

        void trackComplete() {
            this.sendEvents(TrackingLive.EVENT_COMPLETE);
        }

        void trackOnEvent() {
            this.sendEvents(TrackingLive.EVENT_ONLINE);
        }

        private void sendEvents(String ... events) {
            String finalEvents = null;
            finalEvents = events.length > 1 ? TextUtils.join((CharSequence)",", (Object[])events) : events[0];
            new RequestTrackerLiveTask().execute(new String[]{finalEvents});
        }

        void destroy() {
            this.cancelOnEventTask();
        }
    }

    private class RequestTrackerLiveTask
    extends AsyncTask<String, Void, Void> {
        private RequestTrackerLiveTask() {
        }

        protected Void doInBackground(String ... params) {
            try {
                Sttm2 sttm2 = TrackingLive.this.getSttm2();
                String event = params[0];
                if (sttm2 != null && !TextUtils.isEmpty((CharSequence)sttm2.key) && !TextUtils.isEmpty((CharSequence)sttm2.url)) {
                    String sttmUrl = String.format("%s?event=%s&cid=%s&pid=%s&lid=%s&cat=%s&org=%s", sttm2.url, event, ((TrackingLive)TrackingLive.this).media.clientId, ((TrackingLive)TrackingLive.this).media.projectId, ((TrackingLive)TrackingLive.this).media.id, ((TrackingLive)TrackingLive.this).media.categoryId, TrackingLive.ORIGIN_SDK_ANDROID);
                    URL url = new URL(sttmUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Authorization", "Bearer " + sttm2.key);
                    conn.setRequestProperty("User-Agent", System.getProperty("http.agent"));
                    conn.getResponseCode();
                }
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Failed to fetch URL", (Throwable)e);
            }
            return null;
        }
    }
}

