/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import java.util.HashMap;
import java.util.Map;

public class DrmRequest {
    private String licenseUrl;
    private HashMap<String, String> urlParams = new HashMap();
    private HashMap<String, String> headerParams = new HashMap();
    private String token;
    private String provider;
    private String drmOfflinePayload;

    public DrmRequest(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getLicenseUrl() {
        String params = this.licenseUrl.contains("?") ? "" : "?";
        String sep = "";
        for (Map.Entry<String, String> kv : this.urlParams.entrySet()) {
            params = params + sep + kv.getKey() + "=" + kv.getValue();
            sep = "&";
        }
        if (this.token != null && !this.token.isEmpty()) {
            params = params + "&ls_session=" + this.token;
        }
        return this.licenseUrl + params;
    }

    public HashMap<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public void addLicenseParam(String k, String v) {
        this.urlParams.put(k, v);
    }

    public void addHeaderParam(String k, String v) {
        this.headerParams.put(k, v);
    }

    public String getLicenseParam(String k) {
        return this.urlParams.get(k);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getDrmOfflinePayload() {
        return this.drmOfflinePayload;
    }

    public void setDrmOfflinePayload(String drmOfflinePayload) {
        this.drmOfflinePayload = drmOfflinePayload;
    }
}

