/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.sambatech.player.cast.CastTimeline;
import com.sambatech.player.cast.CastTimelineTracker;
import com.sambatech.player.cast.CastUtils;
import com.sambatech.player.cast.SambaCast;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONException;
import org.json.JSONObject;

public final class CastPlayer
implements Player {
    private final Context context;
    private static final String TAG = "CastPlayer";
    private static final int RENDERER_COUNT = 3;
    private static final int RENDERER_INDEX_VIDEO = 0;
    private static final int RENDERER_INDEX_AUDIO = 1;
    private static final int RENDERER_INDEX_TEXT = 2;
    private static final long PROGRESS_REPORT_PERIOD_MS = 1000L;
    private static final TrackSelectionArray EMPTY_TRACK_SELECTION_ARRAY = new TrackSelectionArray(new TrackSelection[]{null, null, null});
    private static final long[] EMPTY_TRACK_ID_ARRAY = new long[0];
    private final CastContext castContext;
    private final CastTimelineTracker timelineTracker;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private RemoteMediaClient remoteMediaClient;
    private final StatusListener statusListener;
    private final SeekResultCallback seekResultCallback;
    private final CopyOnWriteArraySet<Player.EventListener> listeners;
    private SessionAvailabilityListener sessionAvailabilityListener;
    private CastTimeline currentTimeline;
    private TrackGroupArray currentTrackGroups;
    private TrackSelectionArray currentTrackSelection;
    private int playbackState;
    private int repeatMode;
    private int currentWindowIndex = -1;
    private boolean playWhenReady = false;
    private static long previousReportedPositionMs = 0L;
    private long lastReportedPositionMs = 0L;
    private long lastReportedDurationMs;
    private int pendingSeekCount;
    private int pendingSeekWindowIndex;
    private long pendingSeekPositionMs;
    private boolean waitingForInitialTimeline;
    private boolean isLive;
    private SambaCast sambaCast;
    private List<MediaQueueItem> mediaQueueItems;
    Cast.MessageReceivedCallback messageReceived = new Cast.MessageReceivedCallback(){

        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
            Log.i((String)"Message Received", (String)(castDevice.toString() + namespace + message));
            try {
                String type;
                JSONObject jsonObject = new JSONObject(message);
                if (jsonObject.has("progress") && jsonObject.has("duration")) {
                    previousReportedPositionMs = CastPlayer.this.lastReportedPositionMs;
                    CastPlayer.this.lastReportedPositionMs = (long)(jsonObject.getDouble("progress") * 1000.0);
                    CastPlayer.this.lastReportedDurationMs = (long)(jsonObject.getDouble("duration") * 1000.0);
                    CastPlayer.this.updateInternalState();
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(CastPlayer.this.lastReportedPositionMs), Float.valueOf(CastPlayer.this.lastReportedDurationMs)));
                } else if (jsonObject.has("type") && (type = (jsonObject = new JSONObject(message)).getString("type")).equalsIgnoreCase("finish")) {
                    CastPlayer.this.loadItem((MediaQueueItem)CastPlayer.this.mediaQueueItems.get(0), 0L);
                    CastPlayer.this.seekTo(0L);
                    CastPlayer.this.playWhenReady = false;
                    SambaCast.setCurrentStatus(CastPlayer.this.context, CastPlayer.this.playWhenReady);
                    CastPlayer.this.updateInternalState();
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.CAST_FINISH));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    };

    public CastPlayer(Context context, SambaCast sambaCast) {
        this.context = context;
        this.sambaCast = sambaCast;
        this.castContext = sambaCast.getCastContext();
        this.timelineTracker = new CastTimelineTracker();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.statusListener = new StatusListener();
        this.seekResultCallback = new SeekResultCallback();
        this.listeners = new CopyOnWriteArraySet();
        SessionManager sessionManager = this.castContext.getSessionManager();
        sessionManager.addSessionManagerListener((SessionManagerListener)this.statusListener, CastSession.class);
        CastSession session = sessionManager.getCurrentCastSession();
        this.remoteMediaClient = session != null ? session.getRemoteMediaClient() : null;
        this.playbackState = 3;
        this.repeatMode = 0;
        this.currentTimeline = CastTimeline.EMPTY_CAST_TIMELINE;
        this.currentTrackGroups = TrackGroupArray.EMPTY;
        this.currentTrackSelection = EMPTY_TRACK_SELECTION_ARRAY;
        this.pendingSeekWindowIndex = -1;
        this.pendingSeekPositionMs = -9223372036854775807L;
        this.updateInternalState();
    }

    public void setMessageListener(CastSession castSession) {
        try {
            castSession.setMessageReceivedCallbacks("urn:x-cast:com.sambatech.player", this.messageReceived);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> loadItem(MediaQueueItem item, long positionMs) {
        return this.loadItems(new MediaQueueItem[]{item}, 0, positionMs, 0);
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> loadItems(MediaQueueItem[] items, int startIndex, long positionMs, int repeatMode) {
        if (this.remoteMediaClient != null) {
            positionMs = positionMs != -9223372036854775807L ? positionMs : 0L;
            this.waitingForInitialTimeline = true;
            this.mediaQueueItems = new ArrayList<MediaQueueItem>();
            Collections.addAll(this.mediaQueueItems, items);
            return this.remoteMediaClient.queueLoad(items, startIndex, CastPlayer.getCastRepeatMode(repeatMode), positionMs, null);
        }
        return null;
    }

    public void resumeItems(MediaQueueItem[] items, int startIndex, int repeatMode) {
        if (this.remoteMediaClient != null) {
            this.waitingForInitialTimeline = true;
            this.mediaQueueItems = new ArrayList<MediaQueueItem>();
            Collections.addAll(this.mediaQueueItems, items);
        }
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> addItems(MediaQueueItem ... items) {
        return this.addItems(0, items);
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> addItems(int periodId, MediaQueueItem ... items) {
        if (this.getMediaStatus() != null && (periodId == 0 || this.currentTimeline.getIndexOfPeriod(periodId) != -1)) {
            this.mediaQueueItems = new ArrayList<MediaQueueItem>();
            Collections.addAll(this.mediaQueueItems, items);
            return this.remoteMediaClient.queueInsertItems(items, periodId, null);
        }
        return null;
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> removeItem(int periodId) {
        if (this.getMediaStatus() != null && this.currentTimeline.getIndexOfPeriod(periodId) != -1) {
            return this.remoteMediaClient.queueRemoveItem(periodId, null);
        }
        return null;
    }

    public PendingResult<RemoteMediaClient.MediaChannelResult> moveItem(int periodId, int newIndex) {
        Assertions.checkArgument((newIndex >= 0 && newIndex < this.currentTimeline.getPeriodCount() ? 1 : 0) != 0);
        if (this.getMediaStatus() != null && this.currentTimeline.getIndexOfPeriod(periodId) != -1) {
            return this.remoteMediaClient.queueMoveItemToNewIndex(periodId, newIndex, null);
        }
        return null;
    }

    public MediaQueueItem getItem(int periodId) {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && this.currentTimeline.getIndexOfPeriod(periodId) != -1 ? mediaStatus.getItemById(periodId) : null;
    }

    public boolean isCastSessionAvailable() {
        return this.remoteMediaClient != null;
    }

    public void setSessionAvailabilityListener(SessionAvailabilityListener listener) {
        this.sessionAvailabilityListener = listener;
    }

    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return null;
    }

    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return null;
    }

    @Nullable
    public Player.TextComponent getTextComponent() {
        return null;
    }

    public Looper getApplicationLooper() {
        return Looper.getMainLooper();
    }

    public void addListener(Player.EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Player.EventListener listener) {
        this.listeners.remove(listener);
    }

    public int getPlaybackState() {
        return this.playbackState;
    }

    @Nullable
    public ExoPlaybackException getPlaybackError() {
        return null;
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.playWhenReady = playWhenReady;
        SambaCast.setCurrentStatus(this.context, this.playWhenReady);
        if (this.sambaCast == null) {
            return;
        }
        this.updateInternalState();
        if (playWhenReady) {
            this.sambaCast.playCast();
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.CAST_PLAY));
        } else {
            this.sambaCast.pauseCast();
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.CAST_PAUSE));
        }
    }

    public void syncInternalState() {
        this.playWhenReady = SambaCast.getCurrentStatus(this.context);
        this.updateInternalState();
    }

    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    public void seekToDefaultPosition() {
        this.seekTo(0L);
    }

    public void seekToDefaultPosition(int windowIndex) {
        this.seekTo(windowIndex, 0L);
    }

    public void seekTo(long positionMs) {
        this.seekTo(this.getCurrentWindowIndex(), positionMs);
    }

    public void seekTo(int windowIndex, long positionMs) {
        positionMs = positionMs != -9223372036854775807L ? positionMs : 0L;
        this.sambaCast.seekTo((int)positionMs);
        this.lastReportedPositionMs = positionMs;
        ++this.pendingSeekCount;
        this.pendingSeekWindowIndex = windowIndex;
        this.pendingSeekPositionMs = positionMs;
        for (Player.EventListener listener : this.listeners) {
            listener.onPositionDiscontinuity(1);
        }
    }

    public boolean hasPrevious() {
        return false;
    }

    public void previous() {
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
    }

    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
    }

    public PlaybackParameters getPlaybackParameters() {
        return PlaybackParameters.DEFAULT;
    }

    public void stop() {
        this.playbackState = 1;
        this.sambaCast.stopCasting();
    }

    public void stop(boolean reset) {
    }

    public void release() {
        SessionManager sessionManager = this.castContext.getSessionManager();
        sessionManager.removeSessionManagerListener((SessionManagerListener)this.statusListener, CastSession.class);
        sessionManager.endCurrentSession(false);
    }

    public int getRendererCount() {
        return 3;
    }

    public int getRendererType(int index) {
        switch (index) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setRepeatMode(int repeatMode) {
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
    }

    public boolean getShuffleModeEnabled() {
        return false;
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        return this.currentTrackSelection;
    }

    public TrackGroupArray getCurrentTrackGroups() {
        return this.currentTrackGroups;
    }

    public Timeline getCurrentTimeline() {
        return this.currentTimeline;
    }

    @Nullable
    public Object getCurrentManifest() {
        return null;
    }

    public int getCurrentPeriodIndex() {
        return this.getCurrentWindowIndex();
    }

    public int getCurrentWindowIndex() {
        return this.pendingSeekWindowIndex != -1 ? this.pendingSeekWindowIndex : this.currentWindowIndex;
    }

    public int getNextWindowIndex() {
        return this.currentTimeline.isEmpty() ? -1 : this.currentTimeline.getNextWindowIndex(this.getCurrentWindowIndex(), this.repeatMode, false);
    }

    public int getPreviousWindowIndex() {
        return this.currentTimeline.isEmpty() ? -1 : this.currentTimeline.getPreviousWindowIndex(this.getCurrentWindowIndex(), this.repeatMode, false);
    }

    @Nullable
    public Object getCurrentTag() {
        return null;
    }

    public long getDuration() {
        return this.lastReportedDurationMs;
    }

    public long getCurrentPosition() {
        return this.lastReportedPositionMs;
    }

    public long getBufferedPosition() {
        return this.getCurrentPosition();
    }

    public int getBufferedPercentage() {
        return 100;
    }

    public long getTotalBufferedDuration() {
        return 0L;
    }

    public boolean isCurrentWindowDynamic() {
        return true;
    }

    public boolean isCurrentWindowSeekable() {
        return true;
    }

    public boolean isPlayingAd() {
        return false;
    }

    public int getCurrentAdGroupIndex() {
        return -1;
    }

    public int getCurrentAdIndexInAdGroup() {
        return -1;
    }

    public long getContentDuration() {
        return 0L;
    }

    public boolean isLoading() {
        return false;
    }

    public long getContentPosition() {
        return this.getCurrentPosition();
    }

    public long getContentBufferedPosition() {
        return 0L;
    }

    public void updateInternalState() {
        if (this.remoteMediaClient == null) {
            return;
        }
        for (Player.EventListener eventListener : this.listeners) {
            eventListener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
        }
        int repeatMode = CastPlayer.fetchRepeatMode(this.remoteMediaClient);
        for (Player.EventListener listener : this.listeners) {
            listener.onRepeatModeChanged(repeatMode);
        }
        int n = CastPlayer.fetchCurrentWindowIndex(this.getMediaStatus());
        if (this.currentWindowIndex != n && this.pendingSeekCount == 0) {
            this.currentWindowIndex = n;
            for (Player.EventListener listener : this.listeners) {
                listener.onPositionDiscontinuity(0);
            }
        }
        if (this.updateTracksAndSelections()) {
            for (Player.EventListener listener : this.listeners) {
                listener.onTracksChanged(this.currentTrackGroups, this.currentTrackSelection);
            }
        }
        this.maybeUpdateTimelineAndNotify();
    }

    private void maybeUpdateTimelineAndNotify() {
        if (this.updateTimeline()) {
            this.waitingForInitialTimeline = false;
            for (Player.EventListener listener : this.listeners) {
                listener.onTimelineChanged((Timeline)this.currentTimeline, null, 2);
            }
        }
    }

    private boolean updateTimeline() {
        CastTimeline oldTimeline = this.currentTimeline;
        if (this.mediaQueueItems != null && this.mediaQueueItems.size() > 0) {
            this.currentTimeline = this.timelineTracker.getCastTimeline(this.mediaQueueItems, this.mediaQueueItems.get(0).getMedia().getContentId(), this.lastReportedDurationMs * 1000L);
        }
        return !oldTimeline.equals((Object)this.currentTimeline);
    }

    private boolean updateTracksAndSelections() {
        List castMediaTracks;
        if (this.remoteMediaClient == null) {
            return false;
        }
        MediaStatus mediaStatus = this.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus != null ? mediaStatus.getMediaInfo() : null;
        List list = castMediaTracks = mediaInfo != null ? mediaInfo.getMediaTracks() : null;
        if (castMediaTracks == null || castMediaTracks.isEmpty()) {
            boolean hasChanged = !this.currentTrackGroups.isEmpty();
            this.currentTrackGroups = TrackGroupArray.EMPTY;
            this.currentTrackSelection = EMPTY_TRACK_SELECTION_ARRAY;
            return hasChanged;
        }
        long[] activeTrackIds = mediaStatus.getActiveTrackIds();
        if (activeTrackIds == null) {
            activeTrackIds = EMPTY_TRACK_ID_ARRAY;
        }
        TrackGroup[] trackGroups = new TrackGroup[castMediaTracks.size()];
        TrackSelection[] trackSelections = new TrackSelection[3];
        for (int i = 0; i < castMediaTracks.size(); ++i) {
            MediaTrack mediaTrack = (MediaTrack)castMediaTracks.get(i);
            trackGroups[i] = new TrackGroup(new Format[]{CastUtils.mediaTrackToFormat(mediaTrack)});
            long id2 = mediaTrack.getId();
            int trackType = MimeTypes.getTrackType((String)mediaTrack.getContentType());
            int rendererIndex = CastPlayer.getRendererIndexForTrackType(trackType);
            if (!CastPlayer.isTrackActive(id2, activeTrackIds) || rendererIndex == -1 || trackSelections[rendererIndex] != null) continue;
            trackSelections[rendererIndex] = new FixedTrackSelection(trackGroups[i], 0);
        }
        TrackGroupArray newTrackGroups = new TrackGroupArray(trackGroups);
        TrackSelectionArray newTrackSelections = new TrackSelectionArray(trackSelections);
        if (!newTrackGroups.equals((Object)this.currentTrackGroups) || !newTrackSelections.equals((Object)this.currentTrackSelection)) {
            this.currentTrackSelection = new TrackSelectionArray(trackSelections);
            this.currentTrackGroups = new TrackGroupArray(trackGroups);
            return true;
        }
        return false;
    }

    public void setRemoteMediaClient(@Nullable RemoteMediaClient remoteMediaClient) {
        if (this.remoteMediaClient == remoteMediaClient) {
            return;
        }
        if (this.remoteMediaClient != null) {
            this.remoteMediaClient.removeListener((RemoteMediaClient.Listener)this.statusListener);
            this.remoteMediaClient.removeProgressListener((RemoteMediaClient.ProgressListener)this.statusListener);
        }
        this.remoteMediaClient = remoteMediaClient;
        if (remoteMediaClient != null) {
            if (this.sessionAvailabilityListener != null) {
                this.sessionAvailabilityListener.onCastSessionAvailable();
            }
            remoteMediaClient.addListener((RemoteMediaClient.Listener)this.statusListener);
            remoteMediaClient.addProgressListener((RemoteMediaClient.ProgressListener)this.statusListener, 1000L);
            this.updateInternalState();
        } else if (this.sessionAvailabilityListener != null) {
            this.sessionAvailabilityListener.onCastSessionUnavailable();
        }
    }

    @Nullable
    private MediaStatus getMediaStatus() {
        return this.remoteMediaClient != null ? this.remoteMediaClient.getMediaStatus() : null;
    }

    private static int fetchPlaybackState(RemoteMediaClient remoteMediaClient) {
        return previousReportedPositionMs == 0L ? 1 : 3;
    }

    private static int fetchRepeatMode(RemoteMediaClient remoteMediaClient) {
        return 0;
    }

    private static int fetchCurrentWindowIndex(@Nullable MediaStatus mediaStatus) {
        Integer currentItemId = mediaStatus != null ? mediaStatus.getIndexById(mediaStatus.getCurrentItemId()) : null;
        return currentItemId != null ? currentItemId : 0;
    }

    private static boolean isTrackActive(long id2, long[] activeTrackIds) {
        for (long activeTrackId : activeTrackIds) {
            if (activeTrackId != id2) continue;
            return true;
        }
        return false;
    }

    private static int getRendererIndexForTrackType(int trackType) {
        return trackType == 2 ? 0 : (trackType == 1 ? 1 : (trackType == 3 ? 2 : -1));
    }

    private static int getCastRepeatMode(int repeatMode) {
        switch (repeatMode) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public void sendSubtitle(String lenguage) {
        this.sambaCast.changeSubtitle(lenguage);
    }

    public void setIsLive(boolean isLive) {
        this.isLive = isLive;
    }

    private final class SeekResultCallback
    implements ResultCallback<RemoteMediaClient.MediaChannelResult> {
        private SeekResultCallback() {
        }

        public void onResult(@NonNull RemoteMediaClient.MediaChannelResult result) {
            int statusCode = result.getStatus().getStatusCode();
            if (statusCode != 0 && statusCode != 2103) {
                Log.e((String)CastPlayer.TAG, (String)("Seek failed. Error code " + statusCode + ": " + CastUtils.getLogString(statusCode)));
            }
            if (--CastPlayer.this.pendingSeekCount == 0) {
                CastPlayer.this.pendingSeekWindowIndex = -1;
                CastPlayer.this.pendingSeekPositionMs = -9223372036854775807L;
                for (Player.EventListener listener : CastPlayer.this.listeners) {
                    listener.onSeekProcessed();
                }
            }
        }
    }

    private final class StatusListener
    implements RemoteMediaClient.Listener,
    SessionManagerListener<CastSession>,
    RemoteMediaClient.ProgressListener {
        private StatusListener() {
        }

        public void onProgressUpdated(long progressMs, long unusedDurationMs) {
            CastPlayer.this.lastReportedPositionMs = progressMs;
        }

        public void onStatusUpdated() {
            CastPlayer.this.updateInternalState();
        }

        public void onMetadataUpdated() {
        }

        public void onQueueStatusUpdated() {
            CastPlayer.this.maybeUpdateTimelineAndNotify();
        }

        public void onPreloadStatusUpdated() {
        }

        public void onSendingRemoteMediaRequest() {
        }

        public void onAdBreakStatusUpdated() {
        }

        public void onSessionStarted(CastSession castSession, String s) {
            CastPlayer.this.setRemoteMediaClient(castSession.getRemoteMediaClient());
        }

        public void onSessionResumed(CastSession castSession, boolean b) {
            CastPlayer.this.setRemoteMediaClient(castSession.getRemoteMediaClient());
        }

        public void onSessionEnded(CastSession castSession, int i) {
            CastPlayer.this.setRemoteMediaClient(null);
        }

        public void onSessionSuspended(CastSession castSession, int i) {
            CastPlayer.this.setRemoteMediaClient(null);
        }

        public void onSessionResumeFailed(CastSession castSession, int statusCode) {
            Log.e((String)CastPlayer.TAG, (String)("Session resume failed. Error code " + statusCode + ": " + CastUtils.getLogString(statusCode)));
        }

        public void onSessionStarting(CastSession castSession) {
        }

        public void onSessionStartFailed(CastSession castSession, int statusCode) {
            Log.e((String)CastPlayer.TAG, (String)("Session start failed. Error code " + statusCode + ": " + CastUtils.getLogString(statusCode)));
        }

        public void onSessionEnding(CastSession castSession) {
        }

        public void onSessionResuming(CastSession castSession, String s) {
        }
    }

    public static interface SessionAvailabilityListener {
        public void onCastSessionAvailable();

        public void onCastSessionUnavailable();
    }
}

