/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.drm.OfflineLicenseHelper;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.sambatech.player.R;
import com.sambatech.player.event.SambaApiCallback;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaMediaRequest;
import com.sambatech.player.offline.SambaDownloadManager;
import com.sambatech.player.plugins.DrmRequest;
import com.sambatech.player.utils.Helpers;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jose4j.base64url.internal.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SambaApi {
    public static final String SVBPS_SAMBAVIDEOS = "svbps-sambavideos.akamaized.net";
    private Context context;
    private String accessToken;
    private static final Map<String, Integer> outputMap = new HashMap<String, Integer>();

    public SambaApi(Context context, String accessToken) {
        this.context = context;
        this.accessToken = accessToken;
    }

    public void requestMedia(SambaMediaRequest request, SambaApiCallback callback) {
        new RequestMediaTask(callback).execute(new SambaMediaRequest[]{request});
    }

    public void prepareOfflineMedia(SambaMedia sambaMedia, SambaApiCallback callback) {
        SambaMediaConfig sambaMediaConfig = (SambaMediaConfig)sambaMedia;
        if (sambaMediaConfig.drmRequest != null) {
            new RequestOfflineMediaTask(callback).execute(new SambaMediaConfig[]{sambaMediaConfig});
        } else {
            callback.onMediaResponse(sambaMedia);
        }
    }

    public void requestMedia(final SambaMediaRequest[] requests, final SambaApiCallback callback) {
        SambaApiCallback callbackReq = new SambaApiCallback(){
            private int counter = 0;
            private List<SambaMedia> mediaList = new ArrayList<SambaMedia>();

            @Override
            public void onMediaResponse(SambaMedia media) {
                callback.onMediaResponse(media);
                this.mediaList.add(media);
                this.checkLast();
            }

            @Override
            public void onMediaResponseError(Exception e, SambaMediaRequest request) {
                callback.onMediaResponseError(e, request);
                this.checkLast();
            }

            private void checkLast() {
                if (++this.counter == requests.length) {
                    callback.onMediaListResponse(this.mediaList.toArray(new SambaMedia[this.mediaList.size()]));
                }
            }
        };
        for (SambaMediaRequest req : requests) {
            this.requestMedia(req, callbackReq);
        }
    }

    static {
        outputMap.put("_raw", -1);
        outputMap.put("abr", 0);
        outputMap.put("abr_hls", 0);
        outputMap.put("240p", 1);
        outputMap.put("360p", 2);
        outputMap.put("480p", 3);
        outputMap.put("720p", 4);
        outputMap.put("1080p", 5);
    }

    private class RequestOfflineMediaTask
    extends AsyncTask<SambaMediaConfig, Void, Pair<SambaMediaConfig, Exception>> {
        private final SambaApiCallback listener;
        private SambaMediaRequest request;
        private Exception exception;

        RequestOfflineMediaTask(SambaApiCallback listener) {
            this.listener = listener;
        }

        protected Pair<SambaMediaConfig, Exception> doInBackground(SambaMediaConfig ... params) {
            Pair pairResponse;
            try {
                SambaMediaConfig sambaMediaConfig = params[0];
                if (Helpers.isNetworkAvailable(SambaApi.this.context)) {
                    byte[] offlineLicenseKeySetId = android.util.Base64.decode((String)sambaMediaConfig.drmRequest.getDrmOfflinePayload(), (int)0);
                    DefaultHttpDataSourceFactory httpDataSourceFactory = new DefaultHttpDataSourceFactory(SambaDownloadManager.getInstance().getUserAgent());
                    OfflineLicenseHelper offlineLicenseHelper = OfflineLicenseHelper.newWidevineInstance((String)sambaMediaConfig.drmRequest.getLicenseUrl(), (HttpDataSource.Factory)httpDataSourceFactory);
                    Pair remainingSecPair = offlineLicenseHelper.getLicenseDurationRemainingSec(offlineLicenseKeySetId);
                    if (remainingSecPair != null && ((Long)remainingSecPair.first == 0L || (Long)remainingSecPair.second == 0L)) {
                        offlineLicenseKeySetId = offlineLicenseHelper.renewLicense(offlineLicenseKeySetId);
                        sambaMediaConfig.drmRequest.setDrmOfflinePayload(android.util.Base64.encodeToString((byte[])offlineLicenseKeySetId, (int)0));
                        SambaDownloadManager.getInstance().updateDownloadedMedia(sambaMediaConfig);
                    }
                }
                pairResponse = new Pair((Object)sambaMediaConfig, null);
            }
            catch (Exception e) {
                pairResponse = new Pair(null, (Object)e);
            }
            return pairResponse;
        }

        protected void onPostExecute(Pair<SambaMediaConfig, Exception> pairResponse) {
            super.onPostExecute(pairResponse);
            if (pairResponse.first == null) {
                this.listener.onMediaResponseError((Exception)pairResponse.second, null);
                return;
            }
            this.listener.onMediaResponse((SambaMedia)pairResponse.first);
        }
    }

    private class RequestMediaTask
    extends AsyncTask<SambaMediaRequest, Void, SambaMedia> {
        private final SambaApiCallback listener;
        private SambaMediaRequest request;
        private Exception exception;

        RequestMediaTask(SambaApiCallback listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SambaMedia doInBackground(SambaMediaRequest ... params) {
            this.request = params[0];
            int delimiter = this.request.mediaId != null ? Integer.parseInt(this.request.mediaId.split("(?=\\d[a-zA-Z]*$)")[1].substring(0, 1)) : 0;
            InputStream inputStream = null;
            Scanner scanner = null;
            Scanner scannerDelimited = null;
            this.exception = null;
            try {
                inputStream = new URL(this.getRequestUrl(this.request)).openStream();
                scanner = new Scanner(inputStream);
                scannerDelimited = scanner.useDelimiter("\\A");
                if (scannerDelimited.hasNext()) {
                    String token = scannerDelimited.next();
                    token = token.substring(delimiter, token.length() - delimiter).replaceAll("-", "+").replaceAll("_", "/");
                    switch (token.length() % 4) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            token = token + "==";
                            break;
                        }
                        case 3: {
                            token = token + "=";
                            break;
                        }
                    }
                    byte[] tokenBytes = Base64.decodeBase64((String)token);
                    String jsonString = new String(tokenBytes);
                    JSONObject json = new JSONObject(jsonString);
                    SambaMedia sambaMedia = this.parseMedia(json, this.request);
                    return sambaMedia;
                }
            }
            catch (Exception e) {
                this.exception = e;
                Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error opening server request", (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (scanner != null) {
                        scanner.close();
                    }
                    if (scannerDelimited != null) {
                        scannerDelimited.close();
                    }
                }
                catch (IOException e) {
                    this.exception = e;
                    Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error closing server request", (Throwable)e);
                }
            }
            return null;
        }

        private String getRequestUrl(SambaMediaRequest request) {
            String endpoint;
            switch (request.environment) {
                case LOCAL: {
                    endpoint = SambaApi.this.context.getString(R.string.player_endpoint_local);
                    break;
                }
                case DEV: {
                    endpoint = SambaApi.this.context.getString(R.string.player_endpoint_test);
                    break;
                }
                case STAGING: {
                    endpoint = this.normalizeProtocol(SambaApi.this.context.getString(R.string.player_endpoint_staging), request.protocol);
                    break;
                }
                default: {
                    endpoint = this.normalizeProtocol(SambaApi.this.context.getString(R.string.player_endpoint_prod), request.protocol);
                }
            }
            String url = String.format("%s%s/", endpoint, request.projectHash);
            if (request.mediaId != null) {
                url = url + String.format("%s", request.mediaId);
            } else if (request.liveChannelId != null) {
                url = url + String.format("live/%s", request.liveChannelId);
            }
            if (request.streamUrl != null) {
                url = url + String.format("?alternateLive=%s", request.streamUrl);
            } else if (request.streamName != null) {
                url = url + String.format("?streamName=%s", request.streamName);
            }
            return url;
        }

        protected void onPostExecute(SambaMedia media) {
            if (media == null) {
                this.listener.onMediaResponseError(this.exception != null ? this.exception : new Exception("Failed to load media data"), this.request);
                return;
            }
            this.listener.onMediaResponse(media);
        }

        private SambaMedia parseMedia(JSONObject json, SambaMediaRequest request) {
            try {
                String qualifier = json.getString("qualifier").toLowerCase();
                if (!("video".equals(qualifier) || "live".equals(qualifier) || "audio".equals(qualifier))) {
                    return null;
                }
                SambaMediaConfig media = new SambaMediaConfig();
                JSONObject playerConfig = json.getJSONObject("playerConfig");
                JSONObject apiConfig = json.getJSONObject("apiConfig");
                JSONObject playerSecurity = json.optJSONObject("playerSecurity");
                JSONObject projectConfig = json.getJSONObject("project");
                JSONArray ads = json.optJSONArray("advertisings");
                media.request = request;
                media.projectHash = projectConfig.getString("playerHash");
                media.projectId = projectConfig.getInt("id");
                media.title = json.getString("title");
                boolean bl = media.isAudioOnly = "audio".equals(qualifier) || request.isStreamAudio;
                if (json.has("id")) {
                    media.id = json.getString("id");
                }
                if (json.has("clientId")) {
                    media.clientId = json.getInt("clientId");
                }
                if (json.has("categoryId")) {
                    media.categoryId = json.getInt("categoryId");
                }
                if (json.has("deliveryRules")) {
                    this.fillDeliveryRules(json, media);
                } else if (json.has("liveOutput")) {
                    this.fillLive(json, request, media);
                }
                this.fillThumb(json, request, media);
                this.fillCaptions(json, request, media);
                this.fillTheme(media, playerConfig);
                this.fillSttm(request, media, apiConfig);
                this.fillAds(media, ads);
                this.fillSecurity(media, playerSecurity);
                return media;
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Failed to search media", (Throwable)e);
                return null;
            }
        }

        private void fillThumb(JSONObject json, SambaMediaRequest request, SambaMediaConfig media) throws JSONException, IOException {
            JSONArray thumbs = json.optJSONArray("thumbnails");
            if (thumbs != null && thumbs.length() > 0 && !thumbs.getJSONObject(0).isNull("url")) {
                media.thumb = Drawable.createFromStream((InputStream)new URL(this.normalizeProtocol(thumbs.getJSONObject(0).getString("url"), request.protocol)).openStream(), (String)"Thumbnail");
            }
        }

        private void fillAds(SambaMediaConfig media, JSONArray ads) throws JSONException {
            JSONObject ad;
            if (!media.isAudioOnly && ads != null && ads.length() > 0 && "dfp".equalsIgnoreCase((ad = ads.optJSONObject(0)).getString("adServer"))) {
                media.adUrl = ad.getString("tagVast");
            }
        }

        private void fillSecurity(SambaMediaConfig media, JSONObject playerSecurity) {
            if (playerSecurity != null) {
                JSONObject drm = playerSecurity.optJSONObject("drmSecurity");
                if (drm != null) {
                    media.drmRequest = new DrmRequest(drm.optString("widevineSignatureURL"));
                    media.drmRequest.addLicenseParam("SubContentType", drm.optString("subContentType", "Default"));
                    media.drmRequest.addLicenseParam("CrmId", drm.optString("crmId"));
                    media.drmRequest.addLicenseParam("AccountId", drm.optString("accountId"));
                    media.drmRequest.addLicenseParam("ContentId", drm.optString("contentId"));
                    media.drmRequest.addLicenseParam("ApplicationId", drm.optString("applicationId"));
                    media.drmRequest.addHeaderParam("Content-Type", "application/octet-stream");
                    media.drmRequest.setProvider(drm.optString("provider"));
                }
                media.blockIfRooted = playerSecurity.optBoolean("rootedDevices", false);
            }
        }

        private void fillSttm(SambaMediaRequest request, SambaMediaConfig media, JSONObject apiConfig) throws JSONException {
            if (apiConfig.has("sttm")) {
                JSONObject sttm = apiConfig.getJSONObject("sttm");
                media.sttmUrl = this.normalizeProtocol(sttm.optString("url", "http://sttm.sambatech.com.br/collector/__sttm.gif"), request.protocol);
                media.sttmKey = sttm.optString("key", "ae810ebc7f0654c4fadc50935adcf5ec");
                JSONObject sttm2 = apiConfig.getJSONObject("sttm2");
                if (sttm2 != null) {
                    media.sttm2Url = this.normalizeProtocol(sttm2.optString("url", "https://sttm2.sambatech.com/"), request.protocol);
                    media.sttm2Key = sttm2.optString("key", "eyJhbGciOiJIUzM4NCIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzYW1iYXRlY2gtcGxheWVyIiwibmJmIjoxNTM1NDgyNTY0LCJpYXQiOjE1MzU0ODI5ODQsImV4cCI6MTUzNTUyNjE4NH0.AjRlzx_V4z9RVZ0zW3RDc0H2yZOefPy1X7QskVENuQBwatiwnaJiQL26vhGB1mmo");
                }
            }
        }

        private void fillTheme(SambaMediaConfig media, JSONObject playerConfig) throws JSONException {
            String theme = "theme";
            if (playerConfig.has("theme") && !"default".equalsIgnoreCase(playerConfig.getString("theme"))) {
                media.themeColorHex = "#" + playerConfig.getString("theme");
                media.themeColor = (int)Long.parseLong("FF" + playerConfig.getString("theme").replaceAll("^#*", ""), 16);
            }
        }

        private void fillCaptions(JSONObject json, SambaMediaRequest request, SambaMediaConfig media) throws JSONException {
            JSONArray captions = json.optJSONArray("captions");
            if (captions != null && captions.length() > 0) {
                ArrayList<SambaMedia.Caption> captionArray = new ArrayList<SambaMedia.Caption>();
                HashMap<String, String> langLookup = new HashMap<String, String>();
                langLookup.put("pt-br", "Portugu\u00eas");
                langLookup.put("en-us", "Ingl\u00eas");
                langLookup.put("es-es", "Espanhol");
                langLookup.put("it-it", "Italiano");
                langLookup.put("fr-fr", "Franc\u00eas");
                langLookup.put("zh-cn", "Chin\u00eas");
                langLookup.put("ru-ru", "Russo");
                langLookup.put("disable", "Desativar");
                int j = captions.length();
                while (j-- > 0) {
                    JSONObject caption = captions.getJSONObject(j);
                    JSONObject fileInfo = caption.getJSONObject("fileInfo");
                    String lang = fileInfo.getString("captionLanguage").toLowerCase().replace('_', '-');
                    String subtitleType = fileInfo.optBoolean("autoGenerated", false) ? " (Auto)" : (fileInfo.optBoolean("closedCaption", false) ? " (CC)" : "");
                    captionArray.add(new SambaMedia.Caption(this.normalizeProtocol(caption.getString("url"), request.protocol), (String)langLookup.get(lang) + subtitleType, lang, fileInfo.getBoolean("closedCaption"), false));
                }
                captionArray.add(new SambaMedia.Caption(null, (String)langLookup.get("disable"), null, false, true));
                media.captions = captionArray;
            }
        }

        private void fillLive(JSONObject json, SambaMediaRequest request, SambaMediaConfig media) throws JSONException {
            String reHds = "[\\w]+\\.f4m$";
            media.url = this.normalizeProtocol(json.getJSONObject("liveOutput").getString("baseUrl").replaceAll("[\\w]+\\.f4m$", "playlist.m3u8"), request.protocol);
            if (json.getJSONObject("liveOutput").has("backupUrl")) {
                media.backupUrls = new String[]{this.normalizeProtocol(json.getJSONObject("liveOutput").getString("backupUrl").replaceAll("[\\w]+\\.f4m$", "playlist.m3u8"), request.protocol)};
            }
            media.isLive = true;
            boolean bl = media.isDvr = json.getJSONObject("liveOutput").has("dvr") ? json.getJSONObject("liveOutput").getBoolean("dvr") : false;
            if (media.url.contains(".m3u8")) {
                media.type = "hls";
            } else if (media.url.contains(".mpd")) {
                media.type = "dash";
            }
        }

        private void fillDeliveryRules(JSONObject json, SambaMediaConfig media) throws JSONException {
            String outputName = "outputName";
            String progressive = "progressive";
            String defaultOutput = json.getJSONObject("project").getString("defaultOutput");
            JSONArray rules = json.getJSONArray("deliveryRules");
            int totalRules = rules.length();
            ArrayList<String> filledRules = new ArrayList<String>();
            block8: for (int i = 0; i < totalRules; ++i) {
                String type;
                JSONObject rule = rules.getJSONObject(i);
                switch (type = rule.getString("urlType").toLowerCase()) {
                    case "dash": 
                    case "hls": 
                    case "progressive": {
                        if (!filledRules.contains(type) && (!type.equals("progressive") || !filledRules.contains("hls")) && (!type.equals("progressive") && !type.equals("hls") || !filledRules.contains("dash"))) break;
                        continue block8;
                    }
                    default: {
                        continue block8;
                    }
                }
                media.type = type;
                ArrayList<SambaMedia.Output> mediaOutputs = new ArrayList<SambaMedia.Output>();
                JSONArray outputs = rule.getJSONArray("outputs");
                boolean isStreaming = "hls".equals(type) || "dash".equals(type);
                String defaultOutputCurrent = isStreaming ? "abr" : defaultOutput;
                int j = outputs.length();
                while (j-- > 0) {
                    JSONObject output = outputs.getJSONObject(j);
                    String label = output.getString("outputName");
                    SambaMedia.Output cOutput = new SambaMedia.Output();
                    cOutput.url = this.normalizeProtocol(output.getString("url"), this.request.protocol);
                    cOutput.label = output.getString("outputName").startsWith("abr") ? "Auto" : output.getString("outputName");
                    cOutput.position = (Integer)outputMap.get(output.getString("outputName").toLowerCase());
                    media.duration = (float)output.getJSONObject("fileInfo").getLong("duration") / 1000.0f;
                    media.bitrate = output.getJSONObject("fileInfo").getLong("bitrate");
                    if (media.isAudioOnly) {
                        if (isStreaming && cOutput.url.contains(".mp3")) continue;
                        mediaOutputs.add(cOutput);
                        continue;
                    }
                    if ("_raw".equalsIgnoreCase(label) || output.isNull("url")) continue;
                    if (label.startsWith(defaultOutputCurrent)) {
                        media.url = this.normalizeProtocol(output.getString("url"), this.request.protocol);
                        media.defaultOutputIndex = j;
                        cOutput.isDefault = true;
                    }
                    mediaOutputs.add(cOutput);
                }
                if (mediaOutputs.isEmpty()) continue;
                if (media.url == null) {
                    media.url = this.normalizeProtocol(((SambaMedia.Output)mediaOutputs.get((int)0)).url, this.request.protocol);
                }
                media.outputs = mediaOutputs;
                filledRules.add(media.type);
            }
            if (media.outputs != null) {
                this.sortOutputs(media.outputs);
            }
            media.downloadUrl = media.url;
        }

        private void sortOutputs(ArrayList<SambaMedia.Output> outputs) {
            Collections.sort(outputs, new Helpers.CustomSorter());
        }

        private String normalizeProtocol(String url, SambaMediaRequest.Protocol protocol) {
            return url.replaceAll("(https?)", protocol.toString().toLowerCase());
        }

        private String buildDownloadUrl(String url) {
            Uri downloadUri = Uri.parse((String)url);
            Uri.Builder builder = downloadUri.buildUpon();
            builder.clearQuery();
            builder.authority(SambaApi.SVBPS_SAMBAVIDEOS);
            Uri finalDownloadUri = builder.build();
            return finalDownloadUri.toString();
        }
    }
}

