/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer2.ui.SimpleExoPlayerView;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.plugins.Tracking;
import com.sambatech.player.utils.Helpers;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

class TrackingVOD
implements Tracking {
    private SambaMediaConfig media;
    private Sttm sttm;
    private Context context;
    private SambaPlayerListener playerListener = new SambaPlayerListener(){

        @Override
        public void onStart(SambaEvent event) {
            Log.i((String)"sttm", (String)"onstart");
            TrackingVOD.this.init();
            if (TrackingVOD.this.sttm != null) {
                TrackingVOD.this.sttm.trackStart();
            }
        }

        @Override
        public void onProgress(SambaEvent event) {
            if (TrackingVOD.this.sttm != null) {
                TrackingVOD.this.sttm.trackProgress(((Float)event.getDataAll()[0]).floatValue(), ((Float)event.getDataAll()[1]).floatValue());
            }
        }

        @Override
        public void onFinish(SambaEvent event) {
            if (TrackingVOD.this.sttm != null) {
                TrackingVOD.this.sttm.trackComplete();
            }
        }
    };

    TrackingVOD() {
    }

    @Override
    public void onLoad(@NonNull SambaPlayer player) {
        Log.i((String)"track", (String)"load");
        this.media = (SambaMediaConfig)player.getMedia();
        this.context = player.getContext().getApplicationContext();
        if (this.media.projectHash != null && this.media.id != null) {
            SambaEventBus.subscribe(this.playerListener);
        }
        PluginManager.getInstance().notifyPluginLoaded(this);
    }

    @Override
    public void onInternalPlayerCreated(@NonNull SimpleExoPlayerView internalPlayer) {
    }

    @Override
    public void onDestroy() {
        Log.i((String)"track", (String)"destroy");
        SambaEventBus.unsubscribe(this.playerListener);
        if (this.sttm != null) {
            this.sttm.destroy();
            this.sttm = null;
        }
    }

    private void init() {
        if (this.media.sttmUrl != null && this.sttm == null) {
            this.sttm = new Sttm(this.context);
        }
    }

    private class Sttm
    extends TimerTask {
        private final Context context;
        private List<String> targets = new ArrayList<String>();
        private Timer sttmTimer;
        private TreeSet<String> progresses = new TreeSet();
        private HashSet<Integer> trackedRetentions = new HashSet();

        Sttm(Context context) {
            this.context = context;
            this.sttmTimer = new Timer();
            this.sttmTimer.scheduleAtFixedRate((TimerTask)this, 0L, 5000L);
        }

        @Override
        public void run() {
            if (this.targets.size() == 0) {
                return;
            }
            if (Helpers.isNetworkAvailable(this.context)) {
                new UrlTracker().execute(new String[]{String.format("%s?sttmm=%s&sttmk=%s&sttms=%s&sttmu=123&sttmw=%s", ((TrackingVOD)TrackingVOD.this).media.sttmUrl, TextUtils.join((CharSequence)",", this.targets), ((TrackingVOD)TrackingVOD.this).media.sttmKey, ((TrackingVOD)TrackingVOD.this).media.sessionId, String.format("pid:%s/cat:%s/mid:%s", ((TrackingVOD)TrackingVOD.this).media.projectId, ((TrackingVOD)TrackingVOD.this).media.categoryId, ((TrackingVOD)TrackingVOD.this).media.id))});
            }
            this.targets.clear();
        }

        void trackStart() {
            this.targets.add("play");
        }

        void trackComplete() {
            this.collectProgress();
            this.targets.add("complete");
        }

        void trackProgress(float time, float duration) {
            int p = (int)(100.0f * time / duration);
            if (p > 99) {
                p = 99;
            }
            this.progresses.add(String.format(Locale.getDefault(), "p%02d", p));
            if (!this.trackedRetentions.contains(p)) {
                this.progresses.add(String.format(Locale.getDefault(), "r%02d", p));
            }
            this.trackedRetentions.add(p);
            if (this.progresses.size() >= 5) {
                this.collectProgress();
            }
        }

        void destroy() {
            if (this.sttmTimer != null) {
                this.sttmTimer.cancel();
                this.sttmTimer.purge();
                this.sttmTimer = null;
            }
        }

        private void collectProgress() {
            if (this.progresses.size() == 0) {
                return;
            }
            this.targets.add(TextUtils.join((CharSequence)",", this.progresses));
            this.progresses.clear();
        }
    }

    private class UrlTracker
    extends AsyncTask<String, Void, Void> {
        private UrlTracker() {
        }

        protected Void doInBackground(String ... params) {
            try {
                Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)params[0]);
                for (String url : params) {
                    URL myURL = new URL(url);
                    URLConnection conn = myURL.openConnection();
                    conn.setRequestProperty("http.agent", "chrome");
                    conn.setDoOutput(false);
                    conn.setDoInput(true);
                    conn.getInputStream();
                }
            }
            catch (IOException e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Failed to fetch URL", (Throwable)e);
            }
            return null;
        }
    }
}

