/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.net.Uri;
import android.util.Log;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceInputStream;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.util.Util;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CustomDrmCallback
implements MediaDrmCallback {
    private static final String TAG = CustomDrmCallback.class.getSimpleName();
    public static final String LICENSE_PROD = "https://proxy.uat.widevine.com/proxy?provider=widevine_test";
    public static final String LICENSE_STAG = "https://proxy.uat.widevine.com/proxy?provider=widevine_test";
    public static final String LICENSE_TEST = "https://proxy.uat.widevine.com/proxy?provider=widevine_test";
    private final HttpDataSource.Factory dataSourceFactory;
    private final String licUrl;

    public CustomDrmCallback(HttpDataSource.Factory dataSourceFactory, String licUrl, Object ... obj) {
        Log.d((String)TAG, (String)(" license URL  : " + licUrl));
        this.licUrl = licUrl;
        this.dataSourceFactory = dataSourceFactory;
    }

    public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest provisionRequest) throws Exception {
        String url = provisionRequest.getDefaultUrl() + "&signedRequest=" + new String(provisionRequest.getData());
        return this.executePost(url, null, null);
    }

    public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest keyRequest) throws Exception {
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        Uri.Builder builder = Uri.parse((String)this.licUrl).buildUpon();
        requestProperties.put("Content-Type", "text/xml");
        Uri uri = builder.build();
        try {
            return this.executePost(uri.toString(), keyRequest.getData(), requestProperties);
        }
        catch (FileNotFoundException e) {
            throw new IOException("License not found");
        }
        catch (IOException e) {
            throw new IOException("Error during license acquisition", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] executePost(String url, byte[] data, Map<String, String> requestProperties) throws IOException {
        HttpDataSource dataSource = this.dataSourceFactory.createDataSource();
        if (requestProperties != null) {
            for (Map.Entry<String, String> requestProperty : requestProperties.entrySet()) {
                dataSource.setRequestProperty(requestProperty.getKey(), requestProperty.getValue());
            }
        }
        DataSpec dataSpec = new DataSpec(Uri.parse((String)url), data, 0L, 0L, -1L, null, 1);
        DataSourceInputStream inputStream = new DataSourceInputStream((DataSource)dataSource, dataSpec);
        try {
            byte[] byArray = Util.toByteArray((InputStream)inputStream);
            return byArray;
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
        }
    }
}

