/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.content.Context;
import android.net.Uri;
import com.google.android.exoplayer2.offline.DownloadHelper;
import com.google.android.exoplayer2.offline.ProgressiveDownloadHelper;
import com.google.android.exoplayer2.offline.TrackKey;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.upstream.DataSource;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.offline.OfflineUtils;
import com.sambatech.player.offline.SambaTrackNameProvider;
import com.sambatech.player.offline.listeners.SambaDownloadRequestListener;
import com.sambatech.player.offline.model.SambaDownloadRequest;
import com.sambatech.player.offline.model.SambaSubtitle;
import com.sambatech.player.offline.model.SambaTrack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class StartDownloadHelper
implements DownloadHelper.Callback {
    private static final String TAG = "StartDownloadHelper";
    private final DownloadHelper downloadHelper;
    private final String name;
    private final List<TrackKey> trackKeys;
    private final SambaTrackNameProvider trackNameProvider;
    private final Context context;
    private final SambaDownloadRequest sambaDownloadRequest;
    private final SambaDownloadRequestListener requestListener;
    private final List<SambaTrack> sambaVideoTracks;
    private final List<SambaTrack> sambaAudioTracks;
    private final List<SambaSubtitle> sambaSubtitles;
    private final SambaMediaConfig sambaMediaConfig;

    public StartDownloadHelper(Context context, DataSource.Factory dataSourceFactory, SambaDownloadRequest sambaDownloadRequest, SambaDownloadRequestListener requestListener) {
        this.sambaDownloadRequest = sambaDownloadRequest;
        this.requestListener = requestListener;
        this.sambaMediaConfig = (SambaMediaConfig)sambaDownloadRequest.getSambaMedia();
        this.context = context;
        this.downloadHelper = OfflineUtils.getDownloadHelper(Uri.parse((String)this.sambaMediaConfig.downloadUrl), this.sambaMediaConfig.type, dataSourceFactory);
        this.name = this.sambaMediaConfig.title;
        this.trackNameProvider = new SambaTrackNameProvider(context.getResources());
        this.trackKeys = new ArrayList<TrackKey>();
        this.sambaVideoTracks = new ArrayList<SambaTrack>();
        this.sambaAudioTracks = new ArrayList<SambaTrack>();
        this.sambaSubtitles = new ArrayList<SambaSubtitle>();
    }

    public void start() {
        this.downloadHelper.prepare((DownloadHelper.Callback)this);
    }

    public void onPrepared(DownloadHelper helper) {
        if (helper instanceof ProgressiveDownloadHelper) {
            SambaTrack sambaTrack = new SambaTrack(this.sambaMediaConfig.title != null && !this.sambaMediaConfig.title.isEmpty() ? this.sambaMediaConfig.title : "Media", OfflineUtils.getSizeInMB(this.sambaMediaConfig.bitrate, (long)this.sambaMediaConfig.duration));
            if (this.sambaMediaConfig.isAudioOnly) {
                sambaTrack.setAudio(true);
                this.sambaAudioTracks.add(sambaTrack);
            } else {
                this.sambaVideoTracks.add(sambaTrack);
            }
        } else {
            for (int i = 0; i < this.downloadHelper.getPeriodCount(); ++i) {
                TrackGroupArray trackGroups = this.downloadHelper.getTrackGroups(i);
                for (int j = 0; j < trackGroups.length; ++j) {
                    TrackGroup trackGroup = trackGroups.get(j);
                    for (int k = 0; k < trackGroup.length; ++k) {
                        TrackKey trackKey = new TrackKey(i, j, k);
                        SambaTrack sambaTrack = new SambaTrack(this.trackNameProvider.getTrackName(trackGroup.getFormat(k)), OfflineUtils.getSizeInMB(trackGroup.getFormat((int)k).bitrate, (long)this.sambaMediaConfig.duration), trackKey, trackGroup.getFormat((int)k).width, trackGroup.getFormat((int)k).height);
                        if (OfflineUtils.inferPrimaryTrackType(trackGroup.getFormat(k)) == 1) {
                            sambaTrack.setAudio(true);
                            this.sambaAudioTracks.add(sambaTrack);
                            continue;
                        }
                        this.sambaVideoTracks.add(sambaTrack);
                    }
                }
            }
        }
        if (this.sambaMediaConfig.captions != null && !this.sambaMediaConfig.captions.isEmpty()) {
            for (SambaMedia.Caption caption : this.sambaMediaConfig.captions) {
                if (caption.url == null || caption.url.isEmpty() || caption.label == null) continue;
                this.sambaSubtitles.add(new SambaSubtitle(caption.label, caption));
            }
        }
        this.sambaDownloadRequest.setSambaVideoTracks(this.sambaVideoTracks);
        this.sambaDownloadRequest.setSambaAudioTracks(this.sambaAudioTracks);
        this.sambaDownloadRequest.setSambaSubtitles(this.sambaSubtitles);
        this.sambaDownloadRequest.setDownloadHelper(this.downloadHelper);
        this.requestListener.onDownloadRequestPrepared(this.sambaDownloadRequest);
    }

    public void onPrepareError(DownloadHelper helper, IOException e) {
        this.requestListener.onDownloadRequestFailed(new Error(e), "Error to start download");
    }
}

