/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.util.SparseIntArray;
import com.google.android.exoplayer2.Timeline;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.sambatech.player.cast.CastUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class CastTimeline
extends Timeline {
    public static final CastTimeline EMPTY_CAST_TIMELINE = new CastTimeline(Collections.emptyList(), Collections.emptyMap());
    private final SparseIntArray idsToIndex;
    private final int[] ids;
    private final long[] durationsUs;
    private final long[] defaultPositionsUs;

    public CastTimeline(List<MediaQueueItem> items, Map<String, Long> contentIdToDurationUsMap) {
        int itemCount = items.size();
        int index = 0;
        this.idsToIndex = new SparseIntArray(itemCount);
        this.ids = new int[itemCount];
        this.durationsUs = new long[itemCount];
        this.defaultPositionsUs = new long[itemCount];
        for (MediaQueueItem item : items) {
            int itemId;
            this.ids[index] = itemId = item.getItemId();
            this.idsToIndex.put(itemId, index);
            MediaInfo mediaInfo = item.getMedia();
            String contentId = mediaInfo.getContentId();
            this.durationsUs[index] = contentIdToDurationUsMap.containsKey(contentId) ? contentIdToDurationUsMap.get(contentId) : CastUtils.getStreamDurationUs(mediaInfo);
            this.defaultPositionsUs[index] = (long)(item.getStartTime() * 1000000.0);
            ++index;
        }
    }

    public int getWindowCount() {
        return this.ids.length;
    }

    public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setIds, long defaultPositionProjectionUs) {
        long durationUs = this.durationsUs[windowIndex];
        boolean isDynamic = durationUs == -9223372036854775807L;
        return window.set((Object)this.ids[windowIndex], -9223372036854775807L, -9223372036854775807L, !isDynamic, isDynamic, this.defaultPositionsUs[windowIndex], durationUs, windowIndex, windowIndex, 0L);
    }

    public int getPeriodCount() {
        return this.ids.length;
    }

    public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
        int id2 = this.ids[periodIndex];
        return period.set((Object)id2, (Object)id2, periodIndex, this.durationsUs[periodIndex], 0L);
    }

    public int getIndexOfPeriod(Object uid) {
        return uid instanceof Integer ? this.idsToIndex.get(((Integer)uid).intValue(), -1) : -1;
    }

    public Object getUidOfPeriod(int periodIndex) {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CastTimeline)) {
            return false;
        }
        CastTimeline that = (CastTimeline)((Object)other);
        return Arrays.equals(this.ids, that.ids) && Arrays.equals(this.durationsUs, that.durationsUs) && Arrays.equals(this.defaultPositionsUs, that.defaultPositionsUs);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.ids);
        result = 31 * result + Arrays.hashCode(this.durationsUs);
        result = 31 * result + Arrays.hashCode(this.defaultPositionsUs);
        return result;
    }
}

