/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.mediasource;

import android.content.Context;
import android.os.Handler;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.HttpMediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.sambatech.player.model.SambaMediaConfig;
import java.util.UUID;

public class PlayerInstanceDefault {
    Handler mainHandler;
    BandwidthMeter bandwidthMeter;
    AdaptiveTrackSelection.Factory adaptiveTrackSelectionFactory;
    DefaultTrackSelector trackSelector;
    private DefaultRenderersFactory renderersFactory;
    Context context;
    DataSource.Factory mediaDataSourceFactory;
    private HttpMediaDrmCallback drmCallback;
    private DefaultDrmSessionManager drmSessionManager;

    public PlayerInstanceDefault(Context context, SambaMediaConfig media) {
        boolean isDRM = media.drmRequest != null;
        this.context = context;
        this.mainHandler = new Handler();
        this.bandwidthMeter = new DefaultBandwidthMeter();
        this.adaptiveTrackSelectionFactory = new AdaptiveTrackSelection.Factory(this.bandwidthMeter);
        this.trackSelector = new DefaultTrackSelector((TrackSelection.Factory)this.adaptiveTrackSelectionFactory);
        if (isDRM) {
            this.drmCallback = new HttpMediaDrmCallback(media.drmRequest.getLicenseUrl(), (HttpDataSource.Factory)new DefaultHttpDataSourceFactory("user-agent"));
            if (media.drmRequest.getProvider() != null && media.drmRequest.getProvider().equals("SAMBA_DRM")) {
                this.drmCallback.setKeyRequestProperty("Authorization", "Bearer " + media.drmRequest.getToken());
            }
            try {
                this.drmSessionManager = new DefaultDrmSessionManager(C.WIDEVINE_UUID, (ExoMediaDrm)FrameworkMediaDrm.newInstance((UUID)C.WIDEVINE_UUID), (MediaDrmCallback)this.drmCallback, null, this.mainHandler, null);
            }
            catch (UnsupportedDrmException e) {
                e.printStackTrace();
            }
            this.renderersFactory = new DefaultRenderersFactory(this.context, (DrmSessionManager)this.drmSessionManager);
        } else {
            this.renderersFactory = new DefaultRenderersFactory(this.context);
        }
        this.mediaDataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)"mediaPlayerSample"), (TransferListener)this.bandwidthMeter);
    }

    public SimpleExoPlayer createPlayerInstance() {
        return ExoPlayerFactory.newSimpleInstance((RenderersFactory)this.renderersFactory, (TrackSelector)this.trackSelector);
    }

    public void destroy() {
        this.mainHandler = null;
        this.bandwidthMeter = null;
        this.adaptiveTrackSelectionFactory = null;
        this.trackSelector = null;
        this.renderersFactory = null;
        this.mediaDataSourceFactory = null;
        this.drmCallback = null;
        this.drmSessionManager = null;
    }
}

