/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.sambatech.player.event.SambaCastListener;
import com.sambatech.player.utils.SharedPrefsUtils;
import java.io.IOException;

public final class SambaCast {
    private final CastStateListener stateListener = new CastStateListener(){

        public void onCastStateChanged(int i) {
            Log.i((String)"cast", (String)("state: " + i));
        }
    };
    private final AppVisibilityListener appVisibilityListener = new AppVisibilityListener(){

        public void onAppEnteredForeground() {
            Log.i((String)"cast", (String)"foreground");
        }

        public void onAppEnteredBackground() {
            Log.i((String)"cast", (String)"background");
        }
    };
    private final SessionManagerListener<CastSession> sessionManagerListener = new SessionManagerListener<CastSession>(){

        public void onSessionStarting(CastSession castSession) {
            Log.i((String)"cast", (String)"starting");
        }

        public void onSessionStarted(CastSession castSession, String s) {
            Log.i((String)"cast", (String)("started " + s));
            this.onApplicationConnected(castSession);
        }

        public void onSessionStartFailed(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("start failed " + i));
            this.onApplicationDisconnected();
        }

        public void onSessionEnding(CastSession castSession) {
            Log.i((String)"cast", (String)"ending");
        }

        public void onSessionEnded(CastSession castSession, int i) {
            Log.i((String)"cast", (String)"ended");
            this.onApplicationDisconnected();
        }

        public void onSessionResuming(CastSession castSession, String s) {
            Log.i((String)"cast", (String)("resuming " + s));
        }

        public void onSessionResumed(CastSession castSession, boolean b) {
            Log.i((String)"cast", (String)("resumed " + b));
            this.onApplicationConnected(castSession);
        }

        public void onSessionResumeFailed(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("resume failed " + i));
            this.onApplicationDisconnected();
        }

        public void onSessionSuspended(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("suspended " + i));
        }

        private void onApplicationConnected(CastSession castSession) {
            if (SambaCast.this.listener != null) {
                SambaCast.this.listener.onConnected(castSession);
            }
        }

        private void onApplicationDisconnected() {
            SambaCast.cleanCacheDatas(SambaCast.this.context.getApplicationContext());
            if (SambaCast.this.listener != null) {
                SambaCast.this.listener.onDisconnected();
            }
        }
    };
    private Context context;
    private SessionManager sessionManager;
    private CastContext castContext;
    private SambaCastListener listener;
    private boolean isCastButtonOut;

    public SambaCast(@NonNull Context context) {
        int status = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
        if (status != 0) {
            return;
        }
        this.context = context;
        this.castContext = CastContext.getSharedInstance((Context)context);
        this.sessionManager = this.castContext.getSessionManager();
    }

    public void setEventListener(SambaCastListener listener) {
        this.listener = listener;
    }

    public void notifyActivityResume() {
        if (this.castContext != null && this.sessionManager != null) {
            this.castContext.addCastStateListener(this.stateListener);
            this.castContext.addAppVisibilityListener(this.appVisibilityListener);
            this.sessionManager.addSessionManagerListener(this.sessionManagerListener, CastSession.class);
        }
    }

    public void notifyActivityPause() {
        if (this.castContext != null && this.sessionManager != null) {
            this.castContext.removeCastStateListener(this.stateListener);
            this.castContext.removeAppVisibilityListener(this.appVisibilityListener);
            this.sessionManager.removeSessionManagerListener(this.sessionManagerListener, CastSession.class);
        }
    }

    public void pauseCast() {
        String request = "{\"type\": \"pause\"}";
        this.sendRequest(request);
    }

    public void playCast() {
        String request = "{\"type\": \"play\"}";
        this.sendRequest(request);
    }

    public void seekTo(int posisiton) {
        String seekRequest = String.format("{\"type\": \"seek\", \"data\": %s }", posisiton / 1000);
        this.sendRequest(seekRequest);
    }

    public void changeSubtitle(String lang) {
        String data = String.format("{\"lang\": \"%s\"}", lang);
        if (lang == null) {
            data = "{\"lang\": \"none\"}";
        }
        String seekRequest = String.format("{\"type\": \"changeSubtitle\", \"data\": %s }", data);
        this.sendRequest(seekRequest);
    }

    private void sendRequest(String request) {
        if (this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", request).setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void registerDeviceForProgress(boolean register) {
        String registerRequest = String.format("{\"type\": \"registerForProgressUpdate\", \"data\": %s }", register);
        if (this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", registerRequest).setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void stopCasting() {
        this.sessionManager.endCurrentSession(true);
        SambaCast.cleanCacheDatas(this.context);
    }

    public boolean isCasting() {
        if (this.sessionManager != null && this.sessionManager.getCurrentCastSession() != null) {
            return this.sessionManager.getCurrentCastSession().isConnected() || this.sessionManager.getCurrentCastSession().isConnecting();
        }
        return false;
    }

    public void setMute(boolean mute) {
        try {
            this.sessionManager.getCurrentCastSession().setMute(mute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setVolume(double volume) {
        try {
            this.sessionManager.getCurrentCastSession().setVolume(volume);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CastSession getCastSession() {
        return this.sessionManager.getCurrentCastSession();
    }

    private boolean hasMediaSession(boolean validateCastConnectingState) {
        boolean isCastSessionInConnectingMode;
        if (this.sessionManager.getCurrentCastSession() == null) {
            return false;
        }
        boolean isCastSessionValid = this.sessionManager.getCurrentCastSession().isConnected();
        if (validateCastConnectingState && (isCastSessionInConnectingMode = this.sessionManager.getCurrentCastSession().isConnecting())) {
            return false;
        }
        return isCastSessionValid;
    }

    public CastContext getCastContext() {
        return this.castContext;
    }

    @Nullable
    public static String currentMediaCastingId(Context context) {
        return SharedPrefsUtils.getStringPreference(context, "MEDIA_CASTING_KEY");
    }

    public static void cleanCacheDatas(Context context) {
        SharedPrefsUtils.clearPreferenceByKey(context, "MEDIA_CASTING_KEY");
        SharedPrefsUtils.clearPreferenceByKey(context, "PLAYER_STATUS");
    }

    public static void setCurrentMediaCastingId(Context context, String mediaId) {
        SharedPrefsUtils.setStringPreference(context, "MEDIA_CASTING_KEY", mediaId);
    }

    public static void setCurrentStatus(Context context, boolean playWhenReady) {
        SharedPrefsUtils.setBooleanPreference(context, "PLAYER_STATUS", playWhenReady);
    }

    public static boolean getCurrentStatus(Context context) {
        return SharedPrefsUtils.getBooleanPreference(context, "PLAYER_STATUS");
    }

    public boolean isCastButtonOut() {
        return this.isCastButtonOut;
    }

    public void setCastButtonOut(boolean castButtonOut) {
        this.isCastButtonOut = castButtonOut;
    }
}

