/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.content.Context;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionProvider;
import com.sambatech.player.R;
import com.sambatech.player.model.SambaMediaRequest;
import java.util.List;

public final class CastOptionsProvider
implements OptionsProvider {
    public static final String CUSTOM_NAMESPACE = "urn:x-cast:com.sambatech.player";
    public static String appId;
    public static String playerUrl;
    public static SambaMediaRequest.Environment environment;

    public CastOptions getCastOptions(Context context) {
        CastOptionsProvider.configProfile(context, SambaMediaRequest.Environment.PROD, false);
        return new CastOptions.Builder().setReceiverApplicationId(appId).setResumeSavedSession(true).setStopReceiverApplicationWhenEndingSession(true).setEnableReconnectionService(true).build();
    }

    public List<SessionProvider> getAdditionalSessionProviders(Context context) {
        return null;
    }

    public static void configProfile(@NonNull Context context, @NonNull SambaMediaRequest.Environment environment) {
        CastOptionsProvider.configProfile(context, environment, true);
    }

    public static void configProfile(@NonNull Context context, @NonNull SambaMediaRequest.Environment environment, boolean overwrite) {
        if (CastOptionsProvider.environment == null || overwrite) {
            CastOptionsProvider.environment = environment;
        }
        switch (environment) {
            case DEV: {
                if (appId == null || overwrite) {
                    appId = context.getString(R.string.cast_app_id_dev);
                }
                if (playerUrl != null && !overwrite) break;
                playerUrl = context.getString(R.string.base_url_dev);
                break;
            }
            case STAGING: {
                if (appId == null || overwrite) {
                    appId = context.getString(R.string.cast_app_id_staging);
                }
                if (playerUrl != null && !overwrite) break;
                playerUrl = context.getString(R.string.base_url_staging);
                break;
            }
            case PROD: {
                if (appId == null || overwrite) {
                    appId = context.getString(R.string.cast_app_id_prod);
                }
                if (playerUrl != null && !overwrite) break;
                playerUrl = context.getString(R.string.base_url_prod);
            }
        }
    }
}

