/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;

public final class SharedPrefsUtils {
    private SharedPrefsUtils() {
    }

    public static String getStringPreference(Context context, String key) {
        String value = null;
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (preferences != null) {
            value = preferences.getString(key, null);
        }
        return value;
    }

    public static boolean setStringPreference(Context context, String key, String value) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (preferences != null && !TextUtils.isEmpty((CharSequence)key)) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(key, value);
            return editor.commit();
        }
        return false;
    }

    public static void clearPreferenceByKey(Context context, String key) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.remove(key);
            editor.commit();
        }
    }

    public class SharedPrefsKeys {
        public static final String MEDIA_CASTING_KEY = "MEDIA_CASTING_KEY";
    }
}

