/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.google.android.exoplayer.MediaFormat;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;

public class OutputSheetAdapter
extends BaseAdapter {
    @NonNull
    private final Context context;
    @NonNull
    private final MediaFormat[] outputs;
    @NonNull
    private final SambaPlayer player;
    private final int outputOffset;

    public OutputSheetAdapter(@NonNull Context context, @NonNull MediaFormat[] outputs, @NonNull SambaPlayer player, int outputOffset) {
        this.context = context;
        this.outputs = outputs;
        this.player = player;
        this.outputOffset = outputOffset;
    }

    public int getCount() {
        return this.outputs.length - this.outputOffset;
    }

    public Object getItem(int position) {
        return this.outputs[position + this.outputOffset];
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        OutputItem holder;
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        MediaFormat output = (MediaFormat)this.getItem(position);
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.action_sheet_item, parent, false);
            holder = new OutputItem(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (OutputItem)convertView.getTag();
        }
        holder.label.setText((CharSequence)(output.adaptive ? "Auto" : (output.height > 0 ? output.height + "p" : Math.round((float)output.bitrate / 1000.0f) + "k")));
        holder.radio.setChecked(position == this.player.getCurrentOutputIndex());
        return convertView;
    }

    private static class OutputItem {
        TextView label;
        RadioButton radio;

        OutputItem(View view) {
            this.radio = (RadioButton)view.findViewById(R.id.sheet_output_radio);
            this.label = (TextView)view.findViewById(R.id.sheet_item_label);
        }
    }
}

