/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.utils.RootUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Comparator;
import java.util.Scanner;

public final class Helpers {
    public static String getSessionId() {
        StringBuilder s = new StringBuilder();
        int i = 8;
        while (i-- > 0) {
            s.append(Helpers.getSessionComponent());
            switch (i) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    s.append("-");
                }
            }
        }
        return s.toString();
    }

    public static boolean isDeviceRooted() {
        return RootUtil.isDeviceRooted();
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    private static String getSessionComponent() {
        return Integer.toHexString((int)((Math.random() + 1.0) * 65536.0)).substring(1);
    }

    public static void requestUrl(String url, RequestCallback callback) {
        try {
            Helpers.requestUrl((HttpURLConnection)new URL(url).openConnection(), callback);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void requestUrl(HttpURLConnection con, final RequestCallback callback) {
        new AsyncTask<HttpURLConnection, Void, Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Response doInBackground(HttpURLConnection ... params) {
                HttpURLConnection con = params[0];
                InputStream inputStream = null;
                Scanner scanner = null;
                Scanner scannerDelimited = null;
                try {
                    con.connect();
                    inputStream = con.getInputStream();
                    scanner = new Scanner(inputStream);
                    scannerDelimited = scanner.useDelimiter("\\A");
                    Response response = new Response(scannerDelimited.hasNext() ? scannerDelimited.next() : "", null);
                    return response;
                }
                catch (Exception e) {
                    Response response = new Response(null, e);
                    return response;
                }
                finally {
                    try {
                        if (con != null) {
                            con.disconnect();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (scanner != null) {
                            scanner.close();
                        }
                        if (scannerDelimited != null) {
                            scannerDelimited.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            protected void onPostExecute(Response response) {
                if (response.error != null) {
                    callback.onError(response.error, response.response);
                    return;
                }
                callback.onSuccess(response.response);
            }
        }.execute((Object[])new HttpURLConnection[]{con});
    }

    private static class Response {
        public final String response;
        public final Exception error;

        Response(String response, Exception error) {
            this.response = response;
            this.error = error;
        }
    }

    public static interface RequestCallback {
        public void onSuccess(String var1);

        public void onError(Exception var1, String var2);
    }

    public static class CustomSorter
    implements Comparator<SambaMedia.Output> {
        @Override
        public int compare(SambaMedia.Output lhs, SambaMedia.Output rhs) {
            return lhs.position - rhs.position;
        }
    }
}

