/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.samaxes.maven.minify.common.ClosureConfig;
import com.samaxes.maven.minify.common.JavaScriptErrorReporter;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.MinifyMojo;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ProcessJSFilesTask
extends ProcessFilesTask {
    private final ClosureConfig closureConfig;

    public ProcessJSFilesTask(Log log, boolean verbose, Integer bufferSize, String charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig, ClosureConfig closureConfig) throws FileNotFoundException {
        super(log, verbose, bufferSize, charset, suffix, nosuffix, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, engine, yuiConfig);
        this.closureConfig = closureConfig;
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            in = new FileInputStream(mergedFile);
            out = new FileOutputStream(minifiedFile);
            reader = new InputStreamReader((InputStream)in, this.charset);
            writer = new OutputStreamWriter((OutputStream)out, this.charset);
            this.log.info((CharSequence)("Creating the minified file [" + (this.verbose ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
            switch (this.engine) {
                case CLOSURE: {
                    this.log.debug((CharSequence)"Using Google Closure Compiler engine.");
                    CompilerOptions options = new CompilerOptions();
                    this.closureConfig.getCompilationLevel().setOptionsForCompilationLevel(options);
                    options.setOutputCharset(this.charset);
                    options.setLanguageIn(this.closureConfig.getLanguage());
                    File sourceMapResult = new File(minifiedFile.getPath() + ".map");
                    if (this.closureConfig.getSourceMapFormat() != null) {
                        options.setSourceMapFormat(this.closureConfig.getSourceMapFormat());
                        options.setSourceMapOutputPath(sourceMapResult.getPath());
                    }
                    SourceFile input = SourceFile.fromInputStream((String)mergedFile.getName(), (InputStream)in);
                    List<SourceFile> externs = this.closureConfig.getExterns();
                    Compiler compiler = new Compiler();
                    compiler.compile(externs, (List)Lists.newArrayList((Object[])new SourceFile[]{input}), options);
                    if (compiler.hasErrors()) {
                        throw new EvaluatorException(compiler.getErrors()[0].description);
                    }
                    writer.append(compiler.toSource());
                    if (this.closureConfig.getSourceMapFormat() == null) break;
                    this.log.info((CharSequence)("Creating the minified file map [" + (this.verbose ? sourceMapResult.getPath() : sourceMapResult.getName()) + "]."));
                    sourceMapResult.createNewFile();
                    this.flushSourceMap(sourceMapResult, minifiedFile.getName(), compiler.getSourceMap());
                    writer.append(System.getProperty("line.separator"));
                    writer.append("//# sourceMappingURL=" + sourceMapResult.getName());
                    break;
                }
                case YUI: {
                    this.log.debug((CharSequence)"Using YUI Compressor engine.");
                    JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, mergedFile.getName()));
                    compressor.compress((Writer)writer, this.yuiConfig.getLineBreak(), this.yuiConfig.isMunge(), this.verbose, this.yuiConfig.isPreserveSemicolons(), this.yuiConfig.isDisableOptimizations());
                    break;
                }
                default: {
                    this.log.warn((CharSequence)"JavaScript engine not supported.");
                }
            }
        }
        catch (IOException e) {
            try {
                this.log.error((CharSequence)("Failed to compress the JavaScript file [" + (this.verbose ? mergedFile.getPath() : mergedFile.getName()) + "]."), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        this.logCompressionGains(mergedFile, minifiedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSourceMap(File sourceMapOutputFile, String minifyFileName, SourceMap sourceMap) {
        FileWriter out = null;
        try {
            out = new FileWriter(sourceMapOutputFile);
            sourceMap.appendTo((Appendable)out, minifyFileName);
        }
        catch (IOException e) {
            try {
                this.log.error((CharSequence)("Failed to write the JavaScript Source Map file [" + (this.verbose ? sourceMapOutputFile.getPath() : sourceMapOutputFile.getName()) + "]."), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
        }
        IOUtils.closeQuietly((Writer)out);
    }
}

