/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.common.SourceFilesEnumeration;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.MinifyMojo;
import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class ProcessFilesTask
implements Callable<Object> {
    public static final String TEMP_SUFFIX = ".tmp";
    protected final Log log;
    protected final boolean verbose;
    protected final Integer bufferSize;
    protected final String charset;
    protected final String suffix;
    protected final boolean nosuffix;
    protected final boolean skipMerge;
    protected final boolean skipMinify;
    protected final MinifyMojo.Engine engine;
    protected final YuiConfig yuiConfig;
    private final File sourceDir;
    private final File targetDir;
    private final String mergedFilename;
    private final List<File> files = new ArrayList<File>();
    private final boolean sourceFilesEmpty;
    private final boolean sourceIncludesEmpty;

    public ProcessFilesTask(Log log, boolean verbose, Integer bufferSize, String charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig) throws FileNotFoundException {
        this.log = log;
        this.verbose = verbose;
        this.bufferSize = bufferSize;
        this.charset = charset;
        this.suffix = suffix + ".";
        this.nosuffix = nosuffix;
        this.skipMerge = skipMerge;
        this.skipMinify = skipMinify;
        this.engine = engine;
        this.yuiConfig = yuiConfig;
        this.sourceDir = new File(webappSourceDir + File.separator + inputDir);
        this.targetDir = new File(webappTargetDir + File.separator + outputDir);
        this.mergedFilename = outputFilename;
        for (String sourceFilename : sourceFiles) {
            this.addNewSourceFile(this.mergedFilename, sourceFilename);
        }
        for (File sourceInclude : this.getFilesToInclude(sourceIncludes, sourceExcludes)) {
            if (this.files.contains(sourceInclude)) continue;
            this.addNewSourceFile(this.mergedFilename, sourceInclude);
        }
        this.sourceFilesEmpty = sourceFiles.isEmpty();
        this.sourceIncludesEmpty = sourceIncludes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws IOException {
        Log log = this.log;
        synchronized (log) {
            String fileType = this instanceof ProcessCSSFilesTask ? "CSS" : "JavaScript";
            this.log.info((CharSequence)("Starting " + fileType + " task:"));
            if (!this.files.isEmpty() && (this.targetDir.exists() || this.targetDir.mkdirs())) {
                if (this.skipMerge) {
                    this.log.info((CharSequence)"Skipping the merge step...");
                    String sourceBasePath = this.sourceDir.getAbsolutePath();
                    for (File mergedFile : this.files) {
                        String originalPath = mergedFile.getAbsolutePath();
                        String subPath = originalPath.substring(sourceBasePath.length(), originalPath.lastIndexOf(File.separator));
                        File targetPath = new File(this.targetDir.getAbsolutePath() + subPath);
                        targetPath.mkdirs();
                        String mergedFileBasename = FileUtils.basename((String)mergedFile.getName());
                        mergedFileBasename = mergedFileBasename.substring(0, mergedFileBasename.length() - 1);
                        File minifiedFile = new File(targetPath, this.nosuffix ? mergedFile.getName() : mergedFileBasename + this.suffix + FileUtils.getExtension((String)mergedFile.getName()));
                        this.minify(mergedFile, minifiedFile);
                    }
                } else if (this.skipMinify) {
                    File mergedFile = new File(this.targetDir, this.mergedFilename);
                    this.merge(mergedFile);
                    this.log.info((CharSequence)"Skipping the minify step...");
                } else {
                    File mergedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename + TEMP_SUFFIX : this.mergedFilename);
                    this.merge(mergedFile);
                    File minifiedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename : FileUtils.basename((String)this.mergedFilename) + this.suffix + FileUtils.getExtension((String)this.mergedFilename));
                    this.minify(mergedFile, minifiedFile);
                    if (this.nosuffix && !mergedFile.delete()) {
                        mergedFile.deleteOnExit();
                    }
                }
                this.log.info((CharSequence)"");
            } else if (!this.sourceFilesEmpty || !this.sourceIncludesEmpty) {
                this.log.error((CharSequence)("No valid " + fileType + " source files found to process."));
            }
        }
        return null;
    }

    protected void merge(File mergedFile) throws IOException {
        SequenceInputStream sequence = null;
        FileOutputStream out = null;
        InputStreamReader sequenceReader = null;
        OutputStreamWriter outWriter = null;
        try {
            sequence = new SequenceInputStream(new SourceFilesEnumeration(this.log, this.files, this.verbose));
            out = new FileOutputStream(mergedFile);
            sequenceReader = new InputStreamReader((InputStream)sequence, this.charset);
            outWriter = new OutputStreamWriter((OutputStream)out, this.charset);
            this.log.info((CharSequence)("Creating the merged file [" + (this.verbose ? mergedFile.getPath() : mergedFile.getName()) + "]."));
            IOUtil.copy((Reader)sequenceReader, (Writer)outWriter, (int)this.bufferSize);
        }
        catch (IOException e) {
            try {
                this.log.error((CharSequence)"Failed to concatenate files.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sequenceReader);
                IOUtils.closeQuietly(outWriter);
                IOUtils.closeQuietly(sequence);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)sequenceReader);
        IOUtils.closeQuietly((Writer)outWriter);
        IOUtils.closeQuietly((InputStream)sequence);
        IOUtils.closeQuietly((OutputStream)out);
    }

    abstract void minify(File var1, File var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logCompressionGains(File mergedFile, File minifiedFile) {
        try {
            File temp = File.createTempFile(minifiedFile.getName(), ".gz");
            FileInputStream in = null;
            FileOutputStream out = null;
            GZIPOutputStream outGZIP = null;
            try {
                in = new FileInputStream(minifiedFile);
                out = new FileOutputStream(temp);
                outGZIP = new GZIPOutputStream(out);
                IOUtil.copy((InputStream)in, (OutputStream)outGZIP, (int)this.bufferSize);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outGZIP);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outGZIP);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            this.log.info((CharSequence)("Uncompressed size: " + mergedFile.length() + " bytes."));
            this.log.info((CharSequence)("Compressed size: " + minifiedFile.length() + " bytes minified (" + temp.length() + " bytes gzipped)."));
            temp.deleteOnExit();
        }
        catch (IOException e) {
            this.log.debug((CharSequence)"Failed to calculate the gzipped file size.", (Throwable)e);
        }
    }

    private void addNewSourceFile(String finalFilename, String sourceFilename) throws FileNotFoundException {
        File sourceFile = new File(this.sourceDir, sourceFilename);
        this.addNewSourceFile(finalFilename, sourceFile);
    }

    private void addNewSourceFile(String finalFilename, File sourceFile) throws FileNotFoundException {
        if (sourceFile.exists()) {
            if (finalFilename.equalsIgnoreCase(sourceFile.getName())) {
                this.log.warn((CharSequence)("The source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "] has the same name as the final file."));
            }
        } else {
            throw new FileNotFoundException("The source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "] does not exist.");
        }
        this.log.debug((CharSequence)("Adding source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "]."));
        this.files.add(sourceFile);
    }

    private List<File> getFilesToInclude(List<String> includes, List<String> excludes) {
        ArrayList<File> includedFiles = new ArrayList<File>();
        if (includes != null && !includes.isEmpty()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(includes.toArray(new String[0]));
            scanner.setExcludes(excludes.toArray(new String[0]));
            scanner.addDefaultExcludes();
            scanner.setBasedir(this.sourceDir);
            scanner.scan();
            for (String includedFilename : scanner.getIncludedFiles()) {
                includedFiles.add(new File(this.sourceDir, includedFilename));
            }
            Collections.sort(includedFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
        }
        return includedFiles;
    }
}

