/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.MinifyMojo;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class ProcessCSSFilesTask
extends ProcessFilesTask {
    public ProcessCSSFilesTask(Log log, boolean verbose, Integer bufferSize, String charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig) throws FileNotFoundException {
        super(log, verbose, bufferSize, charset, suffix, nosuffix, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, engine, yuiConfig);
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            in = new FileInputStream(mergedFile);
            out = new FileOutputStream(minifiedFile);
            reader = new InputStreamReader((InputStream)in, this.charset);
            writer = new OutputStreamWriter((OutputStream)out, this.charset);
            this.log.info((CharSequence)("Creating the minified file [" + (this.verbose ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
            switch (this.engine) {
                case YUI: {
                    this.log.debug((CharSequence)"Using YUI Compressor engine.");
                    CssCompressor compressor = new CssCompressor((Reader)reader);
                    compressor.compress((Writer)writer, this.yuiConfig.getLineBreak());
                    break;
                }
                default: {
                    this.log.warn((CharSequence)"CSS engine not supported.");
                }
            }
        }
        catch (IOException e) {
            try {
                this.log.error((CharSequence)("Failed to compress the CSS file [" + (this.verbose ? mergedFile.getPath() : mergedFile.getName()) + "]."), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        this.logCompressionGains(mergedFile, minifiedFile);
    }
}

