/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.samaxes.maven.minify.common.JavaScriptErrorReporter;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessJSFilesTask
extends ProcessFilesTask {
    private String jsEngine;
    private boolean munge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;

    public ProcessJSFilesTask(Log log, Integer bufferSize, boolean debug, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, String suffix, String charset, int linebreak, String jsEngine, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        super(log, bufferSize, debug, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, suffix, charset, linebreak);
        this.jsEngine = jsEngine;
        this.munge = munge;
        this.verbose = verbose;
        this.preserveAllSemiColons = preserveAllSemiColons;
        this.disableOptimizations = disableOptimizations;
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) {
        if (minifiedFile != null) {
            try {
                OutputStreamWriter writer;
                InputStreamReader reader;
                this.log.info((CharSequence)("Creating minified file [" + (this.debug ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
                FileInputStream in = new FileInputStream(mergedFile);
                FileOutputStream out = new FileOutputStream(minifiedFile);
                if (this.charset == null) {
                    reader = new InputStreamReader(in);
                    writer = new OutputStreamWriter(out);
                } else {
                    reader = new InputStreamReader((InputStream)in, this.charset);
                    writer = new OutputStreamWriter((OutputStream)out, this.charset);
                }
                if ("closure".equals(this.jsEngine)) {
                    this.log.debug((CharSequence)"Using JavaScript compressor engine [Google Closure Compiler].");
                    CompilerOptions options = new CompilerOptions();
                    CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
                    options.setOutputCharset(this.charset);
                    SourceFile input = SourceFile.fromInputStream((String)mergedFile.getName(), (InputStream)in);
                    List externs = Collections.emptyList();
                    Compiler compiler = new Compiler();
                    compiler.compile(externs, Arrays.asList(input), options);
                    writer.append(compiler.toSource());
                } else {
                    this.log.debug((CharSequence)"Using JavaScript compressor engine [YUI Compressor].");
                    JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, mergedFile.getName()));
                    compressor.compress((Writer)writer, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
                }
                IOUtil.close((Reader)reader);
                IOUtil.close((Writer)writer);
                IOUtil.close((InputStream)in);
                IOUtil.close((OutputStream)out);
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

