/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.common.FilenameComparator;
import com.samaxes.maven.minify.common.ListOfFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessFilesTask
implements Callable<Object> {
    public static final String TEMP_SUFFIX = ".tmp";
    protected Log log;
    protected boolean debug;
    protected Integer bufferSize;
    protected boolean skipMerge;
    protected boolean skipMinify;
    protected String charset;
    protected int linebreak;
    private String suffix;
    private boolean nosuffix;
    private String mergedFilename;
    private File sourceDir;
    private File targetDir;
    private String extension;
    private boolean sourceFilesEmpty;
    private boolean sourceIncludesEmpty;
    private List<File> files = new ArrayList<File>();

    public ProcessFilesTask(Log log, Integer bufferSize, boolean debug, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, String suffix, boolean nosuffix, String charset, int linebreak) {
        this.log = log;
        this.debug = debug;
        this.bufferSize = bufferSize;
        this.skipMerge = skipMerge;
        this.skipMinify = skipMinify;
        this.mergedFilename = outputFilename;
        this.suffix = suffix;
        this.nosuffix = nosuffix;
        this.charset = charset;
        this.linebreak = linebreak;
        this.sourceDir = new File(webappSourceDir + File.separator + inputDir);
        for (String sourceFilename : sourceFiles) {
            this.addNewSourceFile(this.mergedFilename, sourceFilename);
        }
        for (File sourceInclude : this.getFilesToInclude(sourceIncludes, sourceExcludes)) {
            if (this.files.contains(sourceInclude)) continue;
            this.addNewSourceFile(this.mergedFilename, sourceInclude);
        }
        this.targetDir = new File(webappTargetDir + File.separator + outputDir);
        this.extension = "." + FileUtils.getExtension((String)this.mergedFilename);
        this.sourceFilesEmpty = sourceFiles.isEmpty();
        this.sourceIncludesEmpty = sourceIncludes.isEmpty();
    }

    @Override
    public Object call() {
        if (!this.files.isEmpty() && (this.targetDir.exists() || this.targetDir.mkdirs())) {
            if (this.skipMerge) {
                this.log.info((CharSequence)"Skipping merge step.");
                String sourceBasePath = this.sourceDir.getAbsolutePath();
                for (File mergedFile : this.files) {
                    String originalPath = mergedFile.getAbsolutePath();
                    String subPath = originalPath.substring(sourceBasePath.length(), originalPath.lastIndexOf(File.separator));
                    File targetPath = new File(this.targetDir.getAbsolutePath() + subPath);
                    targetPath.mkdirs();
                    File minifiedFile = new File(targetPath, this.nosuffix ? mergedFile.getName() : mergedFile.getName().replace(this.extension, this.suffix + this.extension));
                    this.minify(mergedFile, minifiedFile);
                }
            } else if (this.skipMinify) {
                File mergedFile = new File(this.targetDir, this.mergedFilename);
                this.merge(mergedFile);
                this.log.info((CharSequence)"Skipping minify step.");
            } else {
                File mergedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename + TEMP_SUFFIX : this.mergedFilename);
                this.merge(mergedFile);
                File minifiedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename : mergedFile.getName().replace(this.extension, this.suffix + this.extension));
                this.minify(mergedFile, minifiedFile);
                if (this.nosuffix && !mergedFile.delete()) {
                    mergedFile.deleteOnExit();
                }
            }
        } else if (!this.sourceFilesEmpty || !this.sourceIncludesEmpty) {
            String fileType = "CSS".equalsIgnoreCase(this.extension.substring(1)) ? "CSS" : "JavaScript";
            this.log.error((CharSequence)("No valid " + fileType + " source files found to process."));
        }
        return null;
    }

    private void merge(File mergedFile) {
        if (mergedFile != null) {
            ListOfFiles listOfFiles = new ListOfFiles(this.log, this.files, this.debug);
            try {
                this.log.info((CharSequence)("Creating merged file [" + (this.debug ? mergedFile.getPath() : mergedFile.getName()) + "]."));
                SequenceInputStream sequence = new SequenceInputStream(listOfFiles);
                FileOutputStream out = new FileOutputStream(mergedFile);
                if (this.charset == null) {
                    IOUtil.copy((InputStream)sequence, (OutputStream)out, (int)this.bufferSize);
                } else {
                    InputStreamReader sequenceReader = new InputStreamReader((InputStream)sequence, this.charset);
                    OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, this.charset);
                    IOUtil.copy((Reader)sequenceReader, (Writer)outWriter, (int)this.bufferSize);
                    IOUtil.close((Reader)sequenceReader);
                    IOUtil.close((Writer)outWriter);
                }
                IOUtil.close((InputStream)sequence);
                IOUtil.close((OutputStream)out);
            }
            catch (IOException e) {
                this.log.error((CharSequence)"An error has occurred while concatenating files.", (Throwable)e);
            }
        }
    }

    abstract void minify(File var1, File var2);

    private void addNewSourceFile(String finalFilename, String sourceFilename) {
        File sourceFile = new File(this.sourceDir, sourceFilename);
        this.addNewSourceFile(finalFilename, sourceFile);
    }

    private void addNewSourceFile(String finalFilename, File sourceFile) {
        if (sourceFile.exists()) {
            if (finalFilename.equalsIgnoreCase(sourceFile.getName())) {
                this.log.warn((CharSequence)("Source file [" + sourceFile.getName() + "] has the same name as the final file."));
            }
            this.log.debug((CharSequence)("Source file [" + sourceFile.getName() + "] added."));
            this.files.add(sourceFile);
        } else {
            this.log.warn((CharSequence)("Source file [" + sourceFile.getName() + "] was not included beacause it does not exist."));
        }
    }

    private List<File> getFilesToInclude(List<String> includes, List<String> excludes) {
        ArrayList<File> includedFiles = new ArrayList<File>();
        if (includes != null && !includes.isEmpty()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(includes.toArray(new String[0]));
            scanner.setExcludes(excludes.toArray(new String[0]));
            scanner.addDefaultExcludes();
            scanner.setBasedir(this.sourceDir);
            scanner.scan();
            for (String includedFilename : scanner.getIncludedFiles()) {
                includedFiles.add(new File(this.sourceDir, includedFilename));
            }
            Collections.sort(includedFiles, new FilenameComparator());
        }
        return includedFiles;
    }
}

