/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCSSFilesTask
extends ProcessFilesTask {
    public ProcessCSSFilesTask(Log log, Integer bufferSize, boolean debug, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, String suffix, boolean nosuffix, String charset, int linebreak) {
        super(log, bufferSize, debug, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, suffix, nosuffix, charset, linebreak);
    }

    @Override
    void minify(File mergedFile, File minifiedFile) {
        if (minifiedFile != null) {
            try {
                OutputStreamWriter writer;
                InputStreamReader reader;
                this.log.info((CharSequence)("Creating minified file [" + (this.debug ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
                FileInputStream in = new FileInputStream(mergedFile);
                FileOutputStream out = new FileOutputStream(minifiedFile);
                if (this.charset == null) {
                    reader = new InputStreamReader(in);
                    writer = new OutputStreamWriter(out);
                } else {
                    reader = new InputStreamReader((InputStream)in, this.charset);
                    writer = new OutputStreamWriter((OutputStream)out, this.charset);
                }
                CssCompressor compressor = new CssCompressor((Reader)reader);
                compressor.compress((Writer)writer, this.linebreak);
                IOUtil.close((Reader)reader);
                IOUtil.close((Writer)writer);
                IOUtil.close((InputStream)in);
                IOUtil.close((OutputStream)out);
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

