/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.minify;

import com.samaxes.maven.plugin.common.FilenameComparator;
import com.samaxes.maven.plugin.common.ListOfFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessFilesTask
implements Runnable {
    protected Log log;
    protected int linebreak;
    protected File mergedFile;
    protected File minifiedFile;
    private Integer bufferSize;
    private String charset;
    private List<File> files = new ArrayList<File>();

    public ProcessFilesTask(Log log, Integer bufferSize, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String finalFilename, String suffix, String charset, int linebreak) {
        this.log = log;
        this.linebreak = linebreak;
        this.bufferSize = bufferSize;
        this.charset = charset;
        File sourceDir = new File(webappSourceDir.concat(File.separator).concat(inputDir));
        File targetDir = new File(webappTargetDir.concat(File.separator).concat(outputDir));
        for (String sourceFile : sourceFiles) {
            this.logNewSourceFile(finalFilename, sourceFile);
            this.files.add(new File(sourceDir, sourceFile));
        }
        for (File sourceInclude : this.getFilesToInclude(sourceDir, sourceIncludes, sourceExcludes)) {
            if (this.files.contains(sourceInclude)) continue;
            this.logNewSourceFile(finalFilename, sourceInclude.getName());
            this.files.add(sourceInclude);
        }
        if (!this.files.isEmpty() && (targetDir.exists() || targetDir.mkdirs())) {
            this.mergedFile = new File(targetDir, finalFilename);
            String extension = ".".concat(FileUtils.getExtension((String)this.mergedFile.getName()));
            this.minifiedFile = new File(targetDir, this.mergedFile.getName().replace(extension, suffix.concat(extension)));
        } else if (!sourceFiles.isEmpty() || !sourceIncludes.isEmpty()) {
            log.error((CharSequence)"An error has occurred while loading source files. Please check your source directory path and source file names.");
        }
    }

    @Override
    public void run() {
        this.mergeFiles();
        this.minify();
    }

    private void logNewSourceFile(String finalFilename, String sourceFilename) {
        if (finalFilename.equalsIgnoreCase(sourceFilename)) {
            this.log.info((CharSequence)"Please be cautious when using the source file name for the final file.");
        }
        this.log.debug((CharSequence)("Adding source file [" + sourceFilename + "]"));
    }

    private List<File> getFilesToInclude(File baseDir, List<String> includes, List<String> excludes) {
        ArrayList<File> includedFiles = new ArrayList<File>();
        if (includes != null && !includes.isEmpty()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(includes.toArray(new String[0]));
            scanner.setExcludes(excludes.toArray(new String[0]));
            scanner.addDefaultExcludes();
            scanner.setBasedir(baseDir);
            scanner.scan();
            for (String includedFilename : scanner.getIncludedFiles()) {
                includedFiles.add(new File(baseDir, includedFilename));
            }
            Collections.sort(includedFiles, new FilenameComparator());
        }
        return includedFiles;
    }

    private void mergeFiles() {
        if (this.mergedFile != null) {
            ListOfFiles listOfFiles = new ListOfFiles(this.log, this.files);
            try {
                this.log.info((CharSequence)("Creating merged file [" + this.mergedFile.getName() + "]"));
                SequenceInputStream sequence = new SequenceInputStream(listOfFiles);
                FileOutputStream out = new FileOutputStream(this.mergedFile);
                if (this.charset == null) {
                    IOUtil.copy((InputStream)sequence, (OutputStream)out, (int)this.bufferSize);
                } else {
                    InputStreamReader sequenceReader = new InputStreamReader((InputStream)sequence, this.charset);
                    OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, this.charset);
                    IOUtil.copy((Reader)sequenceReader, (Writer)outWriter, (int)this.bufferSize);
                    IOUtil.close((Reader)sequenceReader);
                    IOUtil.close((Writer)outWriter);
                }
                IOUtil.close((InputStream)sequence);
                IOUtil.close((OutputStream)out);
            }
            catch (IOException e) {
                this.log.error((CharSequence)"An error has occurred while concatenating files.", (Throwable)e);
            }
        }
    }

    abstract void minify();
}

