/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.codes;

import com.salesforce.servicelibs.com.github.mustachejava.Code;
import com.salesforce.servicelibs.com.github.mustachejava.DefaultMustacheFactory;
import com.salesforce.servicelibs.com.github.mustachejava.Mustache;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheException;
import com.salesforce.servicelibs.com.github.mustachejava.TemplateContext;
import com.salesforce.servicelibs.com.github.mustachejava.codes.DefaultCode;
import com.salesforce.servicelibs.com.github.mustachejava.codes.DefaultMustache;
import com.salesforce.servicelibs.com.github.mustachejava.codes.DepthLimitedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class PartialCode
extends DefaultCode {
    protected final String extension;
    protected final String dir;
    protected Mustache partial;
    protected int recrusionLimit;
    protected boolean isRecursive;

    protected PartialCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String type, String variable) {
        super(tc, df, mustache, variable, type);
        String file = tc.file();
        int dotindex = file.lastIndexOf(".");
        this.extension = dotindex == -1 ? "" : file.substring(dotindex);
        int slashindex = file.lastIndexOf("/");
        this.dir = file.substring(0, slashindex + 1);
        this.recrusionLimit = df.getRecursionLimit();
    }

    public PartialCode(TemplateContext tc, DefaultMustacheFactory cf, String variable) {
        this(tc, cf, null, ">", variable);
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                super.tag(writer, this.type);
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e, this.tc);
        }
    }

    @Override
    public Code[] getCodes() {
        return this.partial == null ? null : this.partial.getCodes();
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.partial.setCodes(newcodes);
    }

    @Override
    public Writer execute(Writer writer, List<Object> scopes) {
        DepthLimitedWriter depthLimitedWriter = null;
        if (this.isRecursive) {
            depthLimitedWriter = writer instanceof DepthLimitedWriter ? (DepthLimitedWriter)writer : new DepthLimitedWriter(writer);
            if (depthLimitedWriter.incr() > this.recrusionLimit) {
                throw new MustacheException("Maximum partial recursion limit reached: " + this.recrusionLimit, this.tc);
            }
            writer = depthLimitedWriter;
        }
        Writer execute = this.partial.execute(writer, scopes);
        if (this.isRecursive) {
            assert (depthLimitedWriter != null);
            depthLimitedWriter.decr();
        }
        return this.appendText(execute);
    }

    @Override
    public synchronized void init() {
        this.filterText();
        this.partial = this.df.compilePartial(this.partialName());
        if (this.partial instanceof DefaultMustache && ((DefaultMustache)this.partial).isRecursive()) {
            this.isRecursive = true;
        }
        if (this.partial == null) {
            throw new MustacheException("Failed to compile partial: " + this.name, this.tc);
        }
    }

    protected String partialName() {
        return this.df.resolvePartialPath(this.dir, this.name, this.extension);
    }
}

