/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.xfcc;

import com.salesforce.grpc.contrib.xfcc.XForwardedClientCert;
import com.salesforce.grpc.contrib.xfcc.XfccQuoteUtil;
import java.util.ArrayList;
import java.util.List;

final class XfccParser {
    private XfccParser() {
    }

    static List<XForwardedClientCert> parse(String header) {
        ArrayList<XForwardedClientCert> certs = new ArrayList<XForwardedClientCert>();
        for (String element : XfccQuoteUtil.quoteAwareSplit(header, ',')) {
            XForwardedClientCert cert = new XForwardedClientCert();
            List<String> substrings = XfccQuoteUtil.quoteAwareSplit(element, ';');
            for (String substring : substrings) {
                List<String> kvp = XfccQuoteUtil.quoteAwareSplit(substring, '=');
                String key = kvp.get(0).toLowerCase();
                String value = kvp.get(1);
                if (key.equalsIgnoreCase("By")) {
                    cert.setBy(XfccQuoteUtil.dequote(value));
                }
                if (key.equalsIgnoreCase("Hash")) {
                    cert.setHash(XfccQuoteUtil.dequote(value));
                }
                if (key.equalsIgnoreCase("SAN") || key.equalsIgnoreCase("URI")) {
                    cert.setSanUri(XfccQuoteUtil.dequote(value));
                }
                if (key.equalsIgnoreCase("DNS")) {
                    cert.addSanDns(XfccQuoteUtil.dequote(value));
                }
                if (!key.equalsIgnoreCase("Subject")) continue;
                cert.setSubject(XfccQuoteUtil.dequote(value));
            }
            certs.add(cert);
        }
        return certs;
    }
}

