/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.xfcc;

import com.salesforce.grpc.contrib.xfcc.XfccQuoteUtil;
import com.salesforce.servicelibs.io.grpc.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class XForwardedClientCert {
    static final String XFCC_BY = "By";
    static final String XFCC_HASH = "Hash";
    static final String XFCC_SAN = "SAN";
    static final String XFCC_URI = "URI";
    static final String XFCC_DNS = "DNS";
    static final String XFCC_SUBJECT = "Subject";
    public static final Context.Key<List<XForwardedClientCert>> XFCC_CONTEXT_KEY = Context.key((String)"x-forwarded-client-cert");
    private String by = "";
    private String hash = "";
    private String sanUri = "";
    private List<String> sanDns = new ArrayList<String>();
    private String subject = "";

    void setBy(String by) {
        this.by = by;
    }

    void setHash(String hash) {
        this.hash = hash;
    }

    void setSanUri(String sanUri) {
        this.sanUri = sanUri;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    void addSanDns(String sanDns) {
        this.sanDns.add(sanDns);
    }

    public String getBy() {
        return this.by;
    }

    public String getHash() {
        return this.hash;
    }

    public String getSanUri() {
        return this.sanUri;
    }

    public Collection<String> getSanDns() {
        return Collections.unmodifiableCollection(this.sanDns);
    }

    public String getSubject() {
        return this.subject;
    }

    public String toString() {
        ArrayList<String> kvp = new ArrayList<String>();
        if (!this.by.isEmpty()) {
            kvp.add(this.toKvp(XFCC_BY, XfccQuoteUtil.enquote(this.by)));
        }
        if (!this.hash.isEmpty()) {
            kvp.add(this.toKvp(XFCC_HASH, XfccQuoteUtil.enquote(this.hash)));
        }
        if (!this.sanUri.isEmpty()) {
            kvp.add(this.toKvp(XFCC_URI, XfccQuoteUtil.enquote(this.sanUri)));
        }
        if (!this.sanDns.isEmpty()) {
            for (String dns : this.sanDns) {
                kvp.add(this.toKvp(XFCC_DNS, XfccQuoteUtil.enquote(dns)));
            }
        }
        if (!this.subject.isEmpty()) {
            kvp.add(this.toKvp(XFCC_SUBJECT, XfccQuoteUtil.enquote(this.subject)));
        }
        return String.join((CharSequence)";", kvp);
    }

    private String toKvp(String key, String value) {
        return key + "=" + value;
    }
}

