/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.instancemode;

import com.salesforce.servicelibs.io.grpc.BindableService;
import com.salesforce.servicelibs.io.grpc.ForwardingServerCallListener;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.MethodDescriptor;
import com.salesforce.servicelibs.io.grpc.ServerCall;
import com.salesforce.servicelibs.io.grpc.ServerCallHandler;
import com.salesforce.servicelibs.io.grpc.ServerMethodDefinition;
import com.salesforce.servicelibs.io.grpc.ServerServiceDefinition;
import com.salesforce.servicelibs.io.grpc.ServiceDescriptor;
import java.util.Collection;
import java.util.function.Supplier;

public class PerCallService<T extends BindableService>
implements BindableService {
    private ServerServiceDefinition perCallBinding;

    public PerCallService(Supplier<T> factory) {
        this.perCallBinding = this.bindService(factory);
    }

    public PerCallService(Class<T> clazz) {
        this(() -> {
            try {
                return (BindableService)clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Class " + clazz.getName() + " must have a public default constructor", e);
            }
        });
    }

    private ServerServiceDefinition bindService(Supplier<T> factory) {
        ServerServiceDefinition baseDefinition = ((BindableService)factory.get()).bindService();
        ServiceDescriptor descriptor = baseDefinition.getServiceDescriptor();
        Collection methods = baseDefinition.getMethods();
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)descriptor);
        methods.forEach(method -> builder.addMethod(ServerMethodDefinition.create((MethodDescriptor)method.getMethodDescriptor(), (ServerCallHandler)new PerCallServerCallHandler(factory))));
        return builder.build();
    }

    public ServerServiceDefinition bindService() {
        return this.perCallBinding;
    }

    private class PerCallServerCallHandler
    implements ServerCallHandler {
        private Supplier<T> factory;

        PerCallServerCallHandler(Supplier<T> factory) {
            this.factory = factory;
        }

        public ServerCall.Listener startCall(ServerCall call, Metadata headers) {
            final BindableService instance = (BindableService)this.factory.get();
            ServerServiceDefinition definition = instance.bindService();
            ServerMethodDefinition method = definition.getMethod(call.getMethodDescriptor().getFullMethodName());
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<T>(method.getServerCallHandler().startCall(call, headers)){

                public void onCancel() {
                    super.onCancel();
                    this.close();
                }

                public void onComplete() {
                    super.onComplete();
                    this.close();
                }

                private void close() {
                    if (instance instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)instance).close();
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                }
            };
        }
    }
}

