/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.servicelibs.com.google.common.base.Preconditions;
import com.salesforce.servicelibs.io.grpc.Context;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.javax.annotation.Nullable;
import com.salesforce.servicelibs.javax.annotation.concurrent.NotThreadSafe;
import java.util.Set;

@NotThreadSafe
public final class AmbientContext {
    static final Context.Key<AmbientContext> DATA_KEY = Context.key((String)"AmbientContext");
    private Metadata contextMetadata = new Metadata();
    private Object freezeKey = null;

    public static Context initialize(Context context) {
        Preconditions.checkNotNull(context, "context");
        Preconditions.checkState(DATA_KEY.get(context) == null, "AmbientContext has already been created in the scope of the current context");
        return context.withValue(DATA_KEY, (Object)new AmbientContext());
    }

    public static AmbientContext current() {
        Preconditions.checkState(DATA_KEY.get() != null, "AmbientContext has not yet been created in the scope of the current context");
        return (AmbientContext)DATA_KEY.get();
    }

    public static boolean isPresent() {
        return DATA_KEY.get() != null;
    }

    AmbientContext() {
    }

    AmbientContext(AmbientContext other) {
        this();
        this.contextMetadata.merge(other.contextMetadata);
    }

    public Object freeze() {
        Preconditions.checkState(!this.isFrozen(), "AmbientContext already frozen. Cannot freeze() twice.");
        this.freezeKey = new Object();
        return this.freezeKey;
    }

    public void thaw(Object freezeKey) {
        Preconditions.checkState(this.isFrozen(), "AmbientContext is not frozen. Cannot thaw().");
        Preconditions.checkArgument(this.freezeKey == freezeKey, "The provided freezeKey is not the same object returned by freeze()");
        this.freezeKey = null;
    }

    public Context fork(Context context) {
        return context.withValue(DATA_KEY, (Object)new AmbientContext(this));
    }

    public boolean isFrozen() {
        return this.freezeKey != null;
    }

    private void checkFreeze() {
        Preconditions.checkState(this.freezeKey == null, "AmbientContext cannot be modified while frozen");
    }

    public boolean containsKey(Metadata.Key<?> key) {
        return this.contextMetadata.containsKey(key);
    }

    public <T> void discardAll(Metadata.Key<T> key) {
        this.checkFreeze();
        this.contextMetadata.discardAll(key);
    }

    @Nullable
    public <T> T get(Metadata.Key<T> key) {
        return (T)this.contextMetadata.get(key);
    }

    @Nullable
    public <T> Iterable<T> getAll(Metadata.Key<T> key) {
        return this.contextMetadata.getAll(key);
    }

    public Set<String> keys() {
        return this.contextMetadata.keys();
    }

    public <T> void put(Metadata.Key<T> key, T value) {
        this.checkFreeze();
        this.contextMetadata.put(key, value);
    }

    public <T> boolean remove(Metadata.Key<T> key, T value) {
        this.checkFreeze();
        return this.contextMetadata.remove(key, value);
    }

    public <T> Iterable<T> removeAll(Metadata.Key<T> key) {
        this.checkFreeze();
        return this.contextMetadata.removeAll(key);
    }

    public String toString() {
        return (this.isFrozen() ? "[FROZEN] " : "[THAWED] ") + this.contextMetadata.toString();
    }
}

