/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.Arrays;
import java.util.List;

public class AggregateClientInterceptor
implements ClientInterceptor {
    private final List<ClientInterceptor> interceptors;

    public AggregateClientInterceptor(ClientInterceptor ... interceptors) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull(interceptors, "interceptors")));
    }

    public AggregateClientInterceptor(List<ClientInterceptor> interceptors) {
        Preconditions.checkNotNull(interceptors, "interceptors");
        Preconditions.checkArgument(interceptors.size() > 0, "AggregateClientInterceptor requires at least one inner ClientInterceptor.");
        this.interceptors = interceptors;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        for (ClientInterceptor interceptor : Lists.reverse(this.interceptors)) {
            next = new InterceptorChannel(next, interceptor);
        }
        return next.newCall(method, callOptions);
    }

    private static final class InterceptorChannel
    extends Channel {
        private final Channel channel;
        private final ClientInterceptor interceptor;

        private InterceptorChannel(Channel channel, ClientInterceptor interceptor) {
            this.channel = channel;
            this.interceptor = Preconditions.checkNotNull(interceptor, "interceptor");
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return this.interceptor.interceptCall(method, callOptions, this.channel);
        }

        public String authority() {
            return this.channel.authority();
        }
    }
}

