/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.google.common.util.concurrent.Runnables;
import io.grpc.stub.StreamObserver;
import java.util.function.Consumer;

public class LambdaStreamObserver<T>
implements StreamObserver<T> {
    private Consumer<T> onNext;
    private Consumer<Throwable> onError;
    private Runnable onCompleted;

    public LambdaStreamObserver(Consumer<T> onNext, Consumer<Throwable> onError, Runnable onCompleted) {
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    public LambdaStreamObserver(Consumer<T> onNext, Consumer<Throwable> onError) {
        this(onNext, onError, Runnables.doNothing());
    }

    public LambdaStreamObserver(Consumer<T> onNext) {
        this(onNext, t -> {
            throw new OnErrorNotImplementedException((Throwable)t);
        }, Runnables.doNothing());
    }

    public void onNext(T value) {
        this.onNext.accept(value);
    }

    public void onError(Throwable t) {
        this.onError.accept(t);
    }

    public void onCompleted() {
        this.onCompleted.run();
    }

    public static final class OnErrorNotImplementedException
    extends RuntimeException {
        private OnErrorNotImplementedException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }
}

