/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpccommon;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactivePublisherBackpressureOnReadyHandler<T>
implements Subscriber<T>,
Runnable {
    private CallStreamObserver<T> requestStream;
    private Subscription subscription;
    private boolean canceled = false;
    private CountDownLatch subscribed = new CountDownLatch(1);

    public ReactivePublisherBackpressureOnReadyHandler(ClientCallStreamObserver<T> requestStream) {
        this.requestStream = (CallStreamObserver)Preconditions.checkNotNull(requestStream);
        requestStream.setOnReadyHandler((Runnable)this);
    }

    public ReactivePublisherBackpressureOnReadyHandler(ServerCallStreamObserver<T> requestStream) {
        this.requestStream = (CallStreamObserver)Preconditions.checkNotNull(requestStream);
        requestStream.setOnReadyHandler((Runnable)this);
        requestStream.setOnCancelHandler(() -> this.subscription.cancel());
    }

    @Override
    public void run() {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Preconditions.checkState((this.subscription != null ? 1 : 0) != 0, (Object)"onSubscribe() not yet called");
        if (!this.isCanceled()) {
            this.subscription.request(1L);
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
        } else {
            this.subscription = (Subscription)Preconditions.checkNotNull((Object)subscription);
            this.subscribed.countDown();
        }
    }

    public void onNext(T t) {
        if (!this.isCanceled()) {
            this.requestStream.onNext(Preconditions.checkNotNull(t));
            if (this.requestStream.isReady()) {
                this.subscription.request(1L);
            }
        }
    }

    public void onError(Throwable throwable) {
        this.requestStream.onError(ReactivePublisherBackpressureOnReadyHandler.prepareError((Throwable)Preconditions.checkNotNull((Object)throwable)));
    }

    public void onComplete() {
        this.requestStream.onCompleted();
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }
}

