/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpccommon;

import com.google.common.base.Preconditions;
import com.salesforce.grpc.contrib.LambdaStreamObserver;
import com.salesforce.reactivegrpccommon.ReactivePublisherBackpressureOnReadyHandler;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

public class ReactiveProducerStreamObserver<TRequest, TResponse>
extends LambdaStreamObserver<TResponse>
implements ClientResponseObserver<TRequest, TResponse> {
    private Publisher<TRequest> rxProducer;
    private ReactivePublisherBackpressureOnReadyHandler<TRequest> onReadyHandler;

    public ReactiveProducerStreamObserver(Publisher<TRequest> rxProducer, Consumer<TResponse> onNext, Consumer<Throwable> onError, Runnable onCompleted) {
        super((Consumer)Preconditions.checkNotNull(onNext), (Consumer)Preconditions.checkNotNull(onError), (Runnable)Preconditions.checkNotNull((Object)onCompleted));
        this.rxProducer = (Publisher)Preconditions.checkNotNull(rxProducer);
    }

    public void beforeStart(ClientCallStreamObserver<TRequest> producerStream) {
        Preconditions.checkNotNull(producerStream);
        this.onReadyHandler = new ReactivePublisherBackpressureOnReadyHandler<TRequest>(producerStream);
    }

    public void rxSubscribe() {
        this.rxProducer.subscribe(this.onReadyHandler);
    }

    public void cancel() {
        this.onReadyHandler.cancel();
    }
}

