/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpccommon;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;

public class CancellableStreamObserver<TRequest, TResponse>
implements ClientResponseObserver<TRequest, TResponse> {
    private final ClientResponseObserver<TRequest, TResponse> delegate;
    private final Runnable onCanceledHandler;

    public CancellableStreamObserver(ClientResponseObserver<TRequest, TResponse> delegate, Runnable onCanceledHandler) {
        this.delegate = delegate;
        this.onCanceledHandler = onCanceledHandler;
    }

    public void onNext(TResponse value) {
        this.delegate.onNext(value);
    }

    public void onError(Throwable t) {
        if (t instanceof StatusException && ((StatusException)t).getStatus().getCode() == Status.Code.CANCELLED) {
            this.onCanceledHandler.run();
        }
        if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode() == Status.Code.CANCELLED) {
            this.onCanceledHandler.run();
        }
        this.delegate.onError(t);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }

    public void beforeStart(ClientCallStreamObserver<TRequest> requestStream) {
        this.delegate.beforeStart(requestStream);
    }
}

