/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc;

import io.reactivex.Flowable;
import io.reactivex.FlowableConverter;
import io.reactivex.FlowableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleConverter;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public final class GrpcRetry {
    private GrpcRetry() {
    }

    public static final class ManyToOne {
        private ManyToOne() {
        }

        public static <I, O> FlowableConverter<I, Single<O>> retryWhen(final Function<Flowable<I>, Single<O>> operation, final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
            return new FlowableConverter<I, Single<O>>(){

                @Override
                public Single<O> apply(final Flowable<I> request) {
                    return Single.defer(new Callable<SingleSource<O>>(){

                        @Override
                        public SingleSource<O> call() throws Exception {
                            return (SingleSource)operation.apply(request);
                        }
                    }).retryWhen(handler);
                }
            };
        }

        public static <I, O> FlowableConverter<I, Single<O>> retryAfter(Function<Flowable<I>, Single<O>> operation, final int delay, final TimeUnit unit) {
            return ManyToOne.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors.flatMap(new Function<Throwable, Publisher<?>>(){

                        @Override
                        public Publisher<?> apply(Throwable error) {
                            return Flowable.timer(delay, unit);
                        }
                    });
                }
            });
        }

        public static <I, O> FlowableConverter<I, Single<O>> retryImmediately(Function<Flowable<I>, Single<O>> operation) {
            return ManyToOne.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors;
                }
            });
        }
    }

    public static final class ManyToMany {
        private ManyToMany() {
        }

        public static <I, O> FlowableTransformer<I, O> retryWhen(final Function<Flowable<I>, Flowable<O>> operation, final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
            return new FlowableTransformer<I, O>(){

                @Override
                public Flowable<O> apply(final Flowable<I> request) {
                    return Flowable.defer(new Callable<Publisher<O>>(){

                        @Override
                        public Publisher<O> call() throws Exception {
                            return (Publisher)operation.apply(request);
                        }
                    }).retryWhen(handler);
                }
            };
        }

        public static <I, O> FlowableTransformer<I, O> retryAfter(Function<Flowable<I>, Flowable<O>> operation, final int delay, final TimeUnit unit) {
            return ManyToMany.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors.flatMap(new Function<Throwable, Publisher<?>>(){

                        @Override
                        public Publisher<?> apply(Throwable error) {
                            return Flowable.timer(delay, unit);
                        }
                    });
                }
            });
        }

        public static <I, O> FlowableTransformer<I, O> retryImmediately(Function<Flowable<I>, Flowable<O>> operation) {
            return ManyToMany.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors;
                }
            });
        }
    }

    public static final class OneToMany {
        private OneToMany() {
        }

        public static <I, O> SingleConverter<I, Flowable<O>> retryWhen(final Function<Single<I>, Flowable<O>> operation, final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
            return new SingleConverter<I, Flowable<O>>(){

                @Override
                public Flowable<O> apply(final Single<I> request) {
                    return Flowable.defer(new Callable<Publisher<O>>(){

                        @Override
                        public Publisher<O> call() throws Exception {
                            return (Publisher)operation.apply(request);
                        }
                    }).retryWhen(handler);
                }
            };
        }

        public static <I, O> SingleConverter<I, Flowable<O>> retryAfter(Function<Single<I>, Flowable<O>> operation, final int delay, final TimeUnit unit) {
            return OneToMany.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors.flatMap(new Function<Throwable, Publisher<?>>(){

                        @Override
                        public Publisher<?> apply(Throwable error) {
                            return Flowable.timer(delay, unit);
                        }
                    });
                }
            });
        }

        public static <I, O> SingleConverter<I, Flowable<O>> retryImmediately(Function<Single<I>, Flowable<O>> operation) {
            return OneToMany.retryWhen(operation, new Function<Flowable<Throwable>, Publisher<?>>(){

                @Override
                public Publisher<?> apply(Flowable<Throwable> errors) {
                    return errors;
                }
            });
        }
    }
}

