/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.google.common.base.Preconditions;
import com.salesforce.reactorgrpc.stub.ReactorCallOptions;
import com.salesforce.reactorgrpc.stub.ReactorServerStreamObserverAndPublisher;
import com.salesforce.reactorgrpc.stub.ReactorSubscriberAndServerProducer;
import io.grpc.CallOptions;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerCalls {
    private ServerCalls() {
    }

    public static <TRequest, TResponse> void oneToOne(TRequest request, StreamObserver<TResponse> responseObserver, Function<TRequest, Mono<TResponse>> delegate, Function<Throwable, Throwable> prepareError) {
        try {
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(request));
            Disposable subscription = rxResponse.subscribe(value -> {
                if (responseObserver instanceof ServerCallStreamObserver && ((ServerCallStreamObserver)responseObserver).isCancelled()) {
                    return;
                }
                responseObserver.onNext(value);
            }, throwable -> responseObserver.onError((Throwable)prepareError.apply((Throwable)throwable)), () -> responseObserver.onCompleted());
            ServerCalls.cancelSubscriptionOnCallEnd(subscription, (ServerCallStreamObserver)responseObserver);
        }
        catch (Throwable throwable2) {
            responseObserver.onError(prepareError.apply(throwable2));
        }
    }

    public static <TRequest, TResponse> void oneToMany(TRequest request, StreamObserver<TResponse> responseObserver, Function<TRequest, Flux<TResponse>> delegate, Function<Throwable, Throwable> prepareError) {
        try {
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(request));
            ReactorSubscriberAndServerProducer server = rxResponse.subscribeWith(new ReactorSubscriberAndServerProducer(prepareError::apply));
            server.subscribe((ServerCallStreamObserver)responseObserver);
        }
        catch (Throwable throwable) {
            responseObserver.onError(prepareError.apply(throwable));
        }
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToOne(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Mono<TResponse>> delegate, Function<Throwable, Throwable> prepareError, CallOptions options) {
        int prefetch = ReactorCallOptions.getPrefetch(options);
        int lowTide = ReactorCallOptions.getLowTide(options);
        ReactorServerStreamObserverAndPublisher streamObserverPublisher = new ReactorServerStreamObserverAndPublisher((ServerCallStreamObserver)responseObserver, null, prefetch, lowTide);
        try {
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(Flux.from(streamObserverPublisher)));
            Disposable subscription = rxResponse.subscribe(value -> {
                if (!streamObserverPublisher.isCancelled()) {
                    responseObserver.onNext(value);
                }
            }, throwable -> {
                if (!streamObserverPublisher.isCancelled()) {
                    streamObserverPublisher.abortPendingCancel();
                    responseObserver.onError((Throwable)prepareError.apply((Throwable)throwable));
                }
            }, () -> responseObserver.onCompleted());
            ServerCalls.cancelSubscriptionOnCallEnd(subscription, (ServerCallStreamObserver)responseObserver);
        }
        catch (Throwable throwable2) {
            responseObserver.onError(prepareError.apply(throwable2));
        }
        return streamObserverPublisher;
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToMany(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Flux<TResponse>> delegate, Function<Throwable, Throwable> prepareError, CallOptions options) {
        int prefetch = ReactorCallOptions.getPrefetch(options);
        int lowTide = ReactorCallOptions.getLowTide(options);
        ReactorServerStreamObserverAndPublisher streamObserverPublisher = new ReactorServerStreamObserverAndPublisher((ServerCallStreamObserver)responseObserver, null, prefetch, lowTide);
        try {
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(Flux.from(streamObserverPublisher)));
            ReactorSubscriberAndServerProducer subscriber = new ReactorSubscriberAndServerProducer(prepareError::apply);
            subscriber.subscribe((ServerCallStreamObserver)responseObserver);
            rxResponse.subscribe(subscriber);
        }
        catch (Throwable throwable) {
            responseObserver.onError(prepareError.apply(throwable));
        }
        return streamObserverPublisher;
    }

    public static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }

    private static void cancelSubscriptionOnCallEnd(Disposable subscription, ServerCallStreamObserver<?> responseObserver) {
        responseObserver.setOnCancelHandler(subscription::dispose);
        responseObserver.setOnCloseHandler(subscription::dispose);
    }
}

