/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.reactivegrpc.jmh.proto.Control;
import com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;

public final class RxWorkerServiceGrpc {
    public static final int METHODID_RUN_SERVER = 0;
    public static final int METHODID_RUN_CLIENT = 1;
    public static final int METHODID_CORE_COUNT = 2;
    public static final int METHODID_QUIT_WORKER = 3;

    private RxWorkerServiceGrpc() {
    }

    public static RxWorkerServiceStub newRxStub(Channel channel) {
        return new RxWorkerServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WorkerServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(WorkerServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Control.CoreRequest)request, responseObserver, new Function<Control.CoreRequest, Single<Control.CoreResponse>>(){

                        @Override
                        public Single<Control.CoreResponse> apply(Control.CoreRequest single) {
                            return serviceImpl.coreCount(single);
                        }
                    }, this.serviceImpl::onErrorMap);
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Control.Void)request, responseObserver, new Function<Control.Void, Single<Control.Void>>(){

                        @Override
                        public Single<Control.Void> apply(Control.Void single) {
                            return serviceImpl.quitWorker(single);
                        }
                    }, this.serviceImpl::onErrorMap);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::runServer, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
                case 1: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::runClient, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WorkerServiceImplBase
    implements BindableService {
        public Flowable<Control.ServerStatus> runServer(Flowable<Control.ServerArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<Control.ClientStatus> runClient(Flowable<Control.ClientArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Control.CoreResponse> coreCount(Control.CoreRequest request) {
            return this.coreCount(Single.just(request));
        }

        public Single<Control.CoreResponse> coreCount(Single<Control.CoreRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Control.Void> quitWorker(Control.Void request) {
            return this.quitWorker(Single.just(request));
        }

        public Single<Control.Void> quitWorker(Single<Control.Void> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)WorkerServiceGrpc.getServiceDescriptor()).addMethod(WorkerServiceGrpc.getRunServerMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).addMethod(WorkerServiceGrpc.getRunClientMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(WorkerServiceGrpc.getCoreCountMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(WorkerServiceGrpc.getQuitWorkerMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }

        protected CallOptions getCallOptions(int methodId) {
            return null;
        }

        protected Throwable onErrorMap(Throwable throwable) {
            return com.salesforce.rxgrpc.stub.ServerCalls.prepareError(throwable);
        }
    }

    public static final class RxWorkerServiceStub
    extends AbstractStub<RxWorkerServiceStub> {
        private WorkerServiceGrpc.WorkerServiceStub delegateStub;

        private RxWorkerServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = WorkerServiceGrpc.newStub(channel);
        }

        private RxWorkerServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WorkerServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxWorkerServiceStub build(Channel channel, CallOptions callOptions) {
            return new RxWorkerServiceStub(channel, callOptions);
        }

        public Flowable<Control.ServerStatus> runServer(Flowable<Control.ServerArgs> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Control.ServerStatus>, StreamObserver<Control.ServerArgs>>(){

                @Override
                public StreamObserver<Control.ServerArgs> apply(StreamObserver<Control.ServerStatus> observer) {
                    return delegateStub.runServer(observer);
                }
            }, this.getCallOptions());
        }

        public Flowable<Control.ClientStatus> runClient(Flowable<Control.ClientArgs> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, new Function<StreamObserver<Control.ClientStatus>, StreamObserver<Control.ClientArgs>>(){

                @Override
                public StreamObserver<Control.ClientArgs> apply(StreamObserver<Control.ClientStatus> observer) {
                    return delegateStub.runClient(observer);
                }
            }, this.getCallOptions());
        }

        public Single<Control.CoreResponse> coreCount(Single<Control.CoreRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, new BiConsumer<Control.CoreRequest, StreamObserver<Control.CoreResponse>>(){

                @Override
                public void accept(Control.CoreRequest request, StreamObserver<Control.CoreResponse> observer) {
                    delegateStub.coreCount(request, observer);
                }
            }, this.getCallOptions());
        }

        public Single<Control.Void> quitWorker(Single<Control.Void> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, new BiConsumer<Control.Void, StreamObserver<Control.Void>>(){

                @Override
                public void accept(Control.Void request, StreamObserver<Control.Void> observer) {
                    delegateStub.quitWorker(request, observer);
                }
            }, this.getCallOptions());
        }

        public Single<Control.CoreResponse> coreCount(Control.CoreRequest rxRequest) {
            return ClientCalls.oneToOne(Single.just(rxRequest), new BiConsumer<Control.CoreRequest, StreamObserver<Control.CoreResponse>>(){

                @Override
                public void accept(Control.CoreRequest request, StreamObserver<Control.CoreResponse> observer) {
                    delegateStub.coreCount(request, observer);
                }
            }, this.getCallOptions());
        }

        public Single<Control.Void> quitWorker(Control.Void rxRequest) {
            return ClientCalls.oneToOne(Single.just(rxRequest), new BiConsumer<Control.Void, StreamObserver<Control.Void>>(){

                @Override
                public void accept(Control.Void request, StreamObserver<Control.Void> observer) {
                    delegateStub.quitWorker(request, observer);
                }
            }, this.getCallOptions());
        }
    }
}

