/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.jmh.proto.Control;
import com.salesforce.reactivegrpc.jmh.proto.WorkerServiceGrpc;
import com.salesforce.reactorgrpc.stub.ClientCalls;
import com.salesforce.reactorgrpc.stub.ServerCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorWorkerServiceGrpc {
    public static final int METHODID_RUN_SERVER = 0;
    public static final int METHODID_RUN_CLIENT = 1;
    public static final int METHODID_CORE_COUNT = 2;
    public static final int METHODID_QUIT_WORKER = 3;

    private ReactorWorkerServiceGrpc() {
    }

    public static ReactorWorkerServiceStub newReactorStub(Channel channel) {
        return new ReactorWorkerServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WorkerServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(WorkerServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    ServerCalls.oneToOne((Control.CoreRequest)request, responseObserver, this.serviceImpl::coreCount, this.serviceImpl::onErrorMap);
                    break;
                }
                case 3: {
                    ServerCalls.oneToOne((Control.Void)request, responseObserver, this.serviceImpl::quitWorker, this.serviceImpl::onErrorMap);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::runServer, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
                case 1: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::runClient, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WorkerServiceImplBase
    implements BindableService {
        public Flux<Control.ServerStatus> runServer(Flux<Control.ServerArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<Control.ClientStatus> runClient(Flux<Control.ClientArgs> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Control.CoreResponse> coreCount(Control.CoreRequest request) {
            return this.coreCount(Mono.just(request));
        }

        public Mono<Control.CoreResponse> coreCount(Mono<Control.CoreRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Control.Void> quitWorker(Control.Void request) {
            return this.quitWorker(Mono.just(request));
        }

        public Mono<Control.Void> quitWorker(Mono<Control.Void> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)WorkerServiceGrpc.getServiceDescriptor()).addMethod(WorkerServiceGrpc.getRunServerMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).addMethod(WorkerServiceGrpc.getRunClientMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(WorkerServiceGrpc.getCoreCountMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(WorkerServiceGrpc.getQuitWorkerMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }

        protected CallOptions getCallOptions(int methodId) {
            return null;
        }

        protected Throwable onErrorMap(Throwable throwable) {
            return ServerCalls.prepareError(throwable);
        }
    }

    public static final class ReactorWorkerServiceStub
    extends AbstractStub<ReactorWorkerServiceStub> {
        private WorkerServiceGrpc.WorkerServiceStub delegateStub;

        private ReactorWorkerServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = WorkerServiceGrpc.newStub(channel);
        }

        private ReactorWorkerServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WorkerServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        protected ReactorWorkerServiceStub build(Channel channel, CallOptions callOptions) {
            return new ReactorWorkerServiceStub(channel, callOptions);
        }

        public Flux<Control.ServerStatus> runServer(Flux<Control.ServerArgs> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::runServer, this.getCallOptions());
        }

        public Flux<Control.ClientStatus> runClient(Flux<Control.ClientArgs> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::runClient, this.getCallOptions());
        }

        public Mono<Control.CoreResponse> coreCount(Mono<Control.CoreRequest> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::coreCount, this.getCallOptions());
        }

        public Mono<Control.Void> quitWorker(Mono<Control.Void> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::quitWorker, this.getCallOptions());
        }

        public Mono<Control.CoreResponse> coreCount(Control.CoreRequest reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::coreCount, this.getCallOptions());
        }

        public Mono<Control.Void> quitWorker(Control.Void reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::quitWorker, this.getCallOptions());
        }
    }
}

