/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.jmh.proto;

import com.salesforce.reactivegrpc.jmh.proto.BenchmarkServiceGrpc;
import com.salesforce.reactivegrpc.jmh.proto.Messages;
import com.salesforce.reactorgrpc.stub.ClientCalls;
import com.salesforce.reactorgrpc.stub.ServerCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorBenchmarkServiceGrpc {
    public static final int METHODID_UNARY_CALL = 0;
    public static final int METHODID_STREAMING_CALL = 1;
    public static final int METHODID_STREAMING_FROM_CLIENT = 2;
    public static final int METHODID_STREAMING_FROM_SERVER = 3;
    public static final int METHODID_STREAMING_BOTH_WAYS = 4;

    private ReactorBenchmarkServiceGrpc() {
    }

    public static ReactorBenchmarkServiceStub newReactorStub(Channel channel) {
        return new ReactorBenchmarkServiceStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final BenchmarkServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(BenchmarkServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((Messages.SimpleRequest)request, responseObserver, this.serviceImpl::unaryCall, this.serviceImpl::onErrorMap);
                    break;
                }
                case 3: {
                    ServerCalls.oneToMany((Messages.SimpleRequest)request, responseObserver, this.serviceImpl::streamingFromServer, this.serviceImpl::onErrorMap);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::streamingCall, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
                case 2: {
                    return ServerCalls.manyToOne(responseObserver, this.serviceImpl::streamingFromClient, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
                case 4: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::streamingBothWays, this.serviceImpl::onErrorMap, this.serviceImpl.getCallOptions(this.methodId));
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class BenchmarkServiceImplBase
    implements BindableService {
        public Mono<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return this.unaryCall(Mono.just(request));
        }

        public Mono<Messages.SimpleResponse> unaryCall(Mono<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<Messages.SimpleResponse> streamingCall(Flux<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Messages.SimpleResponse> streamingFromClient(Flux<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<Messages.SimpleResponse> streamingFromServer(Messages.SimpleRequest request) {
            return this.streamingFromServer(Mono.just(request));
        }

        public Flux<Messages.SimpleResponse> streamingFromServer(Mono<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<Messages.SimpleResponse> streamingBothWays(Flux<Messages.SimpleRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)BenchmarkServiceGrpc.getServiceDescriptor()).addMethod(BenchmarkServiceGrpc.getUnaryCallMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(BenchmarkServiceGrpc.getStreamingCallMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(BenchmarkServiceGrpc.getStreamingFromClientMethod(), io.grpc.stub.ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 2))).addMethod(BenchmarkServiceGrpc.getStreamingFromServerMethod(), io.grpc.stub.ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 3))).addMethod(BenchmarkServiceGrpc.getStreamingBothWaysMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 4))).build();
        }

        protected CallOptions getCallOptions(int methodId) {
            return null;
        }

        protected Throwable onErrorMap(Throwable throwable) {
            return ServerCalls.prepareError(throwable);
        }
    }

    public static final class ReactorBenchmarkServiceStub
    extends AbstractStub<ReactorBenchmarkServiceStub> {
        private BenchmarkServiceGrpc.BenchmarkServiceStub delegateStub;

        private ReactorBenchmarkServiceStub(Channel channel) {
            super(channel);
            this.delegateStub = BenchmarkServiceGrpc.newStub(channel);
        }

        private ReactorBenchmarkServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = BenchmarkServiceGrpc.newStub(channel).build(channel, callOptions);
        }

        protected ReactorBenchmarkServiceStub build(Channel channel, CallOptions callOptions) {
            return new ReactorBenchmarkServiceStub(channel, callOptions);
        }

        public Mono<Messages.SimpleResponse> unaryCall(Mono<Messages.SimpleRequest> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::unaryCall, this.getCallOptions());
        }

        public Flux<Messages.SimpleResponse> streamingCall(Flux<Messages.SimpleRequest> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::streamingCall, this.getCallOptions());
        }

        public Mono<Messages.SimpleResponse> streamingFromClient(Flux<Messages.SimpleRequest> reactorRequest) {
            return ClientCalls.manyToOne(reactorRequest, this.delegateStub::streamingFromClient, this.getCallOptions());
        }

        public Flux<Messages.SimpleResponse> streamingFromServer(Mono<Messages.SimpleRequest> reactorRequest) {
            return ClientCalls.oneToMany(reactorRequest, this.delegateStub::streamingFromServer, this.getCallOptions());
        }

        public Flux<Messages.SimpleResponse> streamingBothWays(Flux<Messages.SimpleRequest> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::streamingBothWays, this.getCallOptions());
        }

        public Mono<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::unaryCall, this.getCallOptions());
        }

        public Flux<Messages.SimpleResponse> streamingFromServer(Messages.SimpleRequest reactorRequest) {
            return ClientCalls.oneToMany(Mono.just(reactorRequest), this.delegateStub::streamingFromServer, this.getCallOptions());
        }
    }
}

