/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subscribers.DisposableSubscriber;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferBoundarySupplier<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Callable<? extends Publisher<B>> boundarySupplier;
    final Callable<U> bufferSupplier;

    public FlowableBufferBoundarySupplier(Flowable<T> source, Callable<? extends Publisher<B>> boundarySupplier, Callable<U> bufferSupplier) {
        super(source);
        this.boundarySupplier = boundarySupplier;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferBoundarySupplierSubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.boundarySupplier));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferBoundarySupplierSubscriber<T, U, B> parent;
        boolean once;

        BufferBoundarySubscriber(BufferBoundarySupplierSubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.cancel();
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            if (this.once) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.once = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.parent.next();
        }
    }

    static final class BufferBoundarySupplierSubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements FlowableSubscriber<T>,
    Subscription,
    Disposable {
        final Callable<U> bufferSupplier;
        final Callable<? extends Publisher<B>> boundarySupplier;
        Subscription upstream;
        final AtomicReference<Disposable> other = new AtomicReference();
        U buffer;

        BufferBoundarySupplierSubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, Callable<? extends Publisher<B>> boundarySupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundarySupplier = boundarySupplier;
        }

        @Override
        public void onSubscribe(Subscription s) {
            Publisher<B> boundary;
            Collection b;
            if (!SubscriptionHelper.validate(this.upstream, s)) {
                return;
            }
            this.upstream = s;
            Subscriber actual = this.downstream;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(e, actual);
                return;
            }
            this.buffer = b;
            try {
                boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary publisher supplied is null");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(ex, actual);
                return;
            }
            BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
            this.other.set(bs);
            actual.onSubscribe(this);
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.cancel();
            this.downstream.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeOther();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        void disposeOther() {
            DisposableHelper.dispose(this.other);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            Publisher<B> boundary;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.downstream.onError(e);
                return;
            }
            try {
                boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary publisher supplied is null");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancelled = true;
                this.upstream.cancel();
                this.downstream.onError(ex);
                return;
            }
            BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
            if (DisposableHelper.replace(this.other, bs)) {
                U b;
                BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
                synchronized (bufferBoundarySupplierSubscriber) {
                    b = this.buffer;
                    if (b == null) {
                        return;
                    }
                    this.buffer = next;
                }
                boundary.subscribe(bs);
                this.fastPathEmitMax(b, false, this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.disposeOther();
        }

        @Override
        public boolean isDisposed() {
            return this.other.get() == DisposableHelper.DISPOSED;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.downstream.onNext(v);
            return true;
        }
    }
}

