/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc.stub;

import io.reactivex.FlowableOperator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscribeOnlyOnceFlowableOperator<T>
implements FlowableOperator<T, T> {
    private AtomicBoolean subscribedOnce = new AtomicBoolean(false);

    @Override
    public Subscriber<? super T> apply(final Subscriber<? super T> observer) {
        return new Subscriber<T>(){

            @Override
            public void onSubscribe(Subscription subscription) {
                if (SubscribeOnlyOnceFlowableOperator.this.subscribedOnce.getAndSet(true)) {
                    throw new NullPointerException("You cannot directly subscribe to a gRPC service multiple times concurrently. Use Flowable.share() instead.");
                }
                observer.onSubscribe(subscription);
            }

            @Override
            public void onNext(T t) {
                observer.onNext(t);
            }

            @Override
            public void onError(Throwable throwable) {
                observer.onError(throwable);
            }

            @Override
            public void onComplete() {
                observer.onComplete();
            }
        };
    }
}

