/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/salesforce/barcodescannerplugin/Utils;", "", "()V", "REQUIRED_PERMISSION", "", "arePermissionsGranted", "", "activity", "Landroid/app/Activity;", "convertImageToBitmap", "Landroid/graphics/Bitmap;", "image", "Landroidx/camera/core/ImageProxy;", "requestPermissions", "", "shouldShowRequestPermissionRationale", "barcodescanner_release"})
public final class Utils {
    private static final String REQUIRED_PERMISSION = "android.permission.CAMERA";
    public static final Utils INSTANCE;

    public final boolean arePermissionsGranted(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        return ContextCompat.checkSelfPermission((Context)((Context)activity), (String)REQUIRED_PERMISSION) == 0;
    }

    public final void requestPermissions(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{REQUIRED_PERMISSION}, (int)0);
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)REQUIRED_PERMISSION);
    }

    @NotNull
    public final Bitmap convertImageToBitmap(@NotNull ImageProxy image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        ImageProxy.PlaneProxy planeProxy = image.getPlanes()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy, (String)"image.planes[0]");
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"image.planes[0].buffer");
        ByteBuffer yBuffer = byteBuffer;
        ImageProxy.PlaneProxy planeProxy2 = image.getPlanes()[1];
        Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy2, (String)"image.planes[1]");
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"image.planes[1].buffer");
        ByteBuffer uBuffer = byteBuffer2;
        ImageProxy.PlaneProxy planeProxy3 = image.getPlanes()[2];
        Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy3, (String)"image.planes[2]");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"image.planes[2].buffer");
        ByteBuffer vBuffer = byteBuffer3;
        int ySize = yBuffer.remaining();
        int uSize = uBuffer.remaining();
        int vSize = vBuffer.remaining();
        byte[] nv21 = new byte[ySize + uSize + vSize];
        yBuffer.get(nv21, 0, ySize);
        vBuffer.get(nv21, ySize, vSize);
        uBuffer.get(nv21, ySize + vSize, uSize);
        YuvImage yuvImage = new YuvImage(nv21, 17, image.getWidth(), image.getHeight(), null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 50, (OutputStream)out);
        byte[] imageBytes = out.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
        Matrix matrix = new Matrix();
        int n = image.getHeight();
        int n2 = image.getWidth();
        int n3 = 0;
        int n4 = 0;
        Bitmap bitmap2 = bitmap;
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$apply = matrix;
        boolean bl3 = false;
        ImageInfo imageInfo = image.getImageInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)imageInfo, (String)"image.imageInfo");
        $this$apply.postRotate((float)imageInfo.getRotationDegrees());
        Matrix matrix2 = matrix;
        Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)n4, (int)n3, (int)n2, (int)n, (Matrix)matrix2, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(\n   \u2026           true\n        )");
        return bitmap3;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

