/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.content.Context;
import android.widget.Toast;
import com.salesforce.barcodescannerplugin.BarcodePluginActivity;
import com.salesforce.barcodescannerplugin.BarcodeScanner;
import com.salesforce.barcodescannerplugin.BarcodeScannerFailure;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.events.FailedScanEvent;
import com.salesforce.barcodescannerplugin.events.ScanStartedEvent;
import com.salesforce.barcodescannerplugin.events.StopScanEvent;
import com.salesforce.barcodescannerplugin.events.SuccessfulScanEvent;
import com.salesforce.nimbus.BoundMethod;
import com.salesforce.nimbus.Plugin;
import com.salesforce.nimbus.PluginOptions;
import com.salesforce.nimbus.Runtime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PluginOptions(name="barcodeScanner")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005JN\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072:\u0010\u0016\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\fH\u0017J(\u0010\u0017\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0017J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020 H\u0007J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0013H\u0002JD\u0010#\u001a\u00020\u00132:\u0010\u0016\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\fH\u0017J\b\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020\u0013H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RD\u0010\u000b\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeScannerPlugin;", "Lcom/salesforce/nimbus/Plugin;", "Lcom/salesforce/barcodescannerplugin/BarcodeScanner;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "eventBus", "Lorg/greenrobot/eventbus/EventBus;", "kotlin.jvm.PlatformType", "scannerCallback", "Lkotlin/Function2;", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerResult;", "Lkotlin/ParameterName;", "name", "barcode", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerFailure;", "failure", "", "beginCapture", "options", "callback", "cleanup", "JavascriptEngine", "EncodedType", "runtime", "Lcom/salesforce/nimbus/Runtime;", "endCapture", "onMessage", "event", "Lcom/salesforce/barcodescannerplugin/events/FailedScanEvent;", "Lcom/salesforce/barcodescannerplugin/events/ScanStartedEvent;", "Lcom/salesforce/barcodescannerplugin/events/SuccessfulScanEvent;", "registerEventBus", "resumeCapture", "showBridgeBrokenMessage", "startScanner", "unRegisterEventBus", "barcodescanner_release"})
public final class BarcodeScannerPlugin
implements Plugin,
BarcodeScanner {
    private Function2<? super BarcodeScannerResult, ? super BarcodeScannerFailure, Unit> scannerCallback;
    private BarcodeScannerOptions barcodeOptions;
    private final EventBus eventBus;
    private final Context context;

    @Override
    @BoundMethod
    public void beginCapture(@Nullable BarcodeScannerOptions options, @NotNull Function2<? super BarcodeScannerResult, ? super BarcodeScannerFailure, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        BarcodeScannerOptions barcodeScannerOptions = options;
        if (barcodeScannerOptions == null) {
            barcodeScannerOptions = new BarcodeScannerOptions(null, null, null, 7, null);
        }
        this.barcodeOptions = barcodeScannerOptions;
        this.scannerCallback = callback2;
        this.startScanner();
    }

    @Override
    @BoundMethod
    public void resumeCapture(@NotNull Function2<? super BarcodeScannerResult, ? super BarcodeScannerFailure, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        this.scannerCallback = callback2;
        this.startScanner();
    }

    @Override
    @BoundMethod
    public void endCapture() {
        EventBus eventBus = this.eventBus;
        boolean bl = false;
        boolean bl2 = false;
        EventBus $this$apply = eventBus;
        boolean bl3 = false;
        $this$apply.post((Object)new StopScanEvent());
        $this$apply.unregister((Object)$this$apply);
    }

    @Subscribe
    public final void onMessage(@NotNull ScanStartedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.registerEventBus();
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public final void onMessage(@NotNull SuccessfulScanEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.eventBus.removeStickyEvent((Object)event);
        if (this.scannerCallback != null) {
            Function2<? super BarcodeScannerResult, ? super BarcodeScannerFailure, Unit> function2 = this.scannerCallback;
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)event.getBarcode(), null);
            }
        } else {
            this.showBridgeBrokenMessage();
        }
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public final void onMessage(@NotNull FailedScanEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.eventBus.removeStickyEvent((Object)event);
        if (this.scannerCallback != null) {
            Function2<? super BarcodeScannerResult, ? super BarcodeScannerFailure, Unit> function2 = this.scannerCallback;
            if (function2 != null) {
                Exception exception = event.getException();
                Unit cfr_ignored_0 = (Unit)function2.invoke(null, (Object)new BarcodeScannerFailure(event.getErrorCode(), exception != null ? exception.toString() : null));
            }
        } else {
            this.showBridgeBrokenMessage();
        }
    }

    public <JavascriptEngine, EncodedType> void cleanup(@NotNull Runtime<JavascriptEngine, EncodedType> runtime) {
        Intrinsics.checkParameterIsNotNull(runtime, (String)"runtime");
        Plugin.DefaultImpls.cleanup((Plugin)this, runtime);
        this.unRegisterEventBus();
    }

    private final void startScanner() {
        this.registerEventBus();
        Context context = this.context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context.applicationContext");
        BarcodeScannerOptions barcodeScannerOptions = this.barcodeOptions;
        if (barcodeScannerOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeOptions");
        }
        this.context.startActivity(BarcodePluginActivity.Companion.getIntent(context, barcodeScannerOptions));
    }

    private final void registerEventBus() {
        if (!this.eventBus.isRegistered((Object)this)) {
            this.eventBus.register((Object)this);
        }
    }

    private final void unRegisterEventBus() {
        this.eventBus.unregister((Object)this);
    }

    private final void showBridgeBrokenMessage() {
        Toast.makeText((Context)this.context, (int)R.string.bridge_broken_message, (int)1).show();
        this.eventBus.post((Object)new StopScanEvent());
    }

    public BarcodeScannerPlugin(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.eventBus = EventBus.getDefault();
        this.registerEventBus();
    }

    public <JavascriptEngine, EncodedType> void customize(@NotNull Runtime<JavascriptEngine, EncodedType> runtime) {
        Intrinsics.checkParameterIsNotNull(runtime, (String)"runtime");
        Plugin.DefaultImpls.customize((Plugin)this, runtime);
    }
}

