/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.camera.core.ImageProxy;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.salesforce.barcodescannerplugin.BarcodeAnalyzer;
import com.salesforce.barcodescannerplugin.BarcodeScannerFailureCode;
import com.salesforce.barcodescannerplugin.BarcodeScannerFocusIndicatorView;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerPreviewView;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.barcodescannerplugin.BarcodeType;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.UtilsKt;
import com.salesforce.barcodescannerplugin.events.FailedScanEvent;
import com.salesforce.barcodescannerplugin.events.ScanStartedEvent;
import com.salesforce.barcodescannerplugin.events.StopScanEvent;
import com.salesforce.barcodescannerplugin.events.SuccessfulScanEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00152\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\b\u0010 \u001a\u00020\u0015H\u0014J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0007J\u0012\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J-\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0015H\u0014J\"\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0010\b\u0002\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0002J\b\u00104\u001a\u00020\u0015H\u0002J\u001a\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010,H\u0002J\u0018\u00109\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010:\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "barcodeAnalyzer", "Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "barcodeScannerOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "eventBus", "Lorg/greenrobot/eventbus/EventBus;", "kotlin.jvm.PlatformType", "eventMessageDeliveryCheckRunnable", "Ljava/lang/Runnable;", "hideLoadingIndicatorRunnable", "mainHandler", "Landroid/os/Handler;", "getPreviewToImageXRation", "", "image", "Landroidx/camera/core/ImageProxy;", "getPreviewToImageYRation", "onBackPressed", "", "onBarcodeDetectFailed", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onBarcodeFound", "barcode", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onMessage", "event", "Lcom/salesforce/barcodescannerplugin/events/StopScanEvent;", "onNewIntent", "intent", "Landroid/content/Intent;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "scanFailed", "code", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerFailureCode;", "startScan", "updateTextViewWithVisibilityCheck", "view", "Landroid/widget/TextView;", "text", "updateViewsForScanSuccess", "updateViewsForStartScan", "Companion", "barcodescanner_release"})
public final class BarcodePluginActivity
extends AppCompatActivity {
    private final EventBus eventBus = EventBus.getDefault();
    private Handler mainHandler;
    private BarcodeScannerOptions barcodeScannerOptions;
    private BarcodeAnalyzer barcodeAnalyzer;
    private final Runnable eventMessageDeliveryCheckRunnable = new Runnable(this){
        final /* synthetic */ BarcodePluginActivity this$0;

        public final void run() {
            if (BarcodePluginActivity.access$getEventBus$p(this.this$0).getStickyEvent(SuccessfulScanEvent.class) != null) {
                this.this$0.finish();
            }
        }
        {
            this.this$0 = barcodePluginActivity;
        }
    };
    private final Runnable hideLoadingIndicatorRunnable = new Runnable(this){
        final /* synthetic */ BarcodePluginActivity this$0;

        public final void run() {
            ProgressBar progressBar = (ProgressBar)this.this$0._$_findCachedViewById(R.id.firebase_ml_loading_indicator);
            Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"firebase_ml_loading_indicator");
            progressBar.setVisibility(8);
        }
        {
            this.this$0 = barcodePluginActivity;
        }
    };
    private static final String OPTIONS_VALUE = "OptionsValue";
    private static final long SUCCESSFUL_SCAN_PROCESS_TIME_THRESHOLD_IN_MS = 1000L;
    private static final long FIREBASE_ML_LOADING_TIME_THRESHOLD_IN_MS = 1000L;
    private static final long ARTIFICIAL_PAUSE_IN_MS = 500L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.barcode_plugin_activity);
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.getLifecycle().addObserver((LifecycleObserver)((BarcodeScannerPreviewView)this._$_findCachedViewById(R.id.preview_view)));
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        this.barcodeScannerOptions = (BarcodeScannerOptions)(bundle != null ? bundle.getSerializable(OPTIONS_VALUE) : null);
        this.barcodeAnalyzer = new BarcodeAnalyzer(this, (Function2<? super List<? extends FirebaseVisionBarcode>, ? super ImageProxy, Unit>)((Function2)new Function2<List<? extends FirebaseVisionBarcode>, ImageProxy, Unit>(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void invoke(@NotNull List<? extends FirebaseVisionBarcode> qrCodes, @NotNull ImageProxy image) {
                Intrinsics.checkParameterIsNotNull(qrCodes, (String)"qrCodes");
                Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
                ProgressBar progressBar = (ProgressBar)this.this$0._$_findCachedViewById(R.id.firebase_ml_loading_indicator);
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"firebase_ml_loading_indicator");
                progressBar.setVisibility(8);
                Collection collection = qrCodes;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    BarcodePluginActivity.access$getBarcodeAnalyzer$p(this.this$0).setPaused(true);
                    FirebaseVisionBarcode barcode = (FirebaseVisionBarcode)CollectionsKt.first(qrCodes);
                    BarcodePluginActivity.access$onBarcodeFound(this.this$0, barcode, image);
                }
            }
            {
                this.this$0 = barcodePluginActivity;
                super(2);
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                BarcodePluginActivity.access$onBarcodeDetectFailed(this.this$0, it);
            }
            {
                this.this$0 = barcodePluginActivity;
                super(1);
            }
        }), this.barcodeScannerOptions);
        ((AppCompatImageButton)this._$_findCachedViewById(R.id.close_button)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void onClick(View it) {
                this.this$0.onBackPressed();
            }
            {
                this.this$0 = barcodePluginActivity;
            }
        });
        this.eventBus.register((Object)this);
    }

    protected void onResume() {
        super.onResume();
        if (Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            this.startScan();
        } else {
            Utils.INSTANCE.requestPermissions((Activity)this);
        }
        this.eventBus.post((Object)new ScanStartedEvent());
    }

    protected void onNewIntent(@Nullable Intent intent) {
        super.onNewIntent(intent);
        BarcodeAnalyzer barcodeAnalyzer = this.barcodeAnalyzer;
        if (barcodeAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeAnalyzer");
        }
        barcodeAnalyzer.setPaused(false);
    }

    protected void onDestroy() {
        Handler handler = this.mainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
        }
        Handler handler2 = handler;
        boolean bl = false;
        boolean bl2 = false;
        Handler $this$apply = handler2;
        boolean bl3 = false;
        $this$apply.removeCallbacks(this.eventMessageDeliveryCheckRunnable);
        $this$apply.removeCallbacks(this.hideLoadingIndicatorRunnable);
        this.eventBus.unregister((Object)this);
        super.onDestroy();
    }

    public void onBackPressed() {
        super.onBackPressed();
        BarcodePluginActivity.scanFailed$default(this, BarcodeScannerFailureCode.USER_DISMISSED_SCANNER, null, 2, null);
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            this.startScan();
        } else {
            BarcodePluginActivity.scanFailed$default(this, Utils.INSTANCE.shouldShowRequestPermissionRationale((Activity)this) ? BarcodeScannerFailureCode.USER_DENIED_PERMISSION : BarcodeScannerFailureCode.USER_DISABLED_PERMISSION, null, 2, null);
        }
    }

    @Subscribe
    public final void onMessage(@NotNull StopScanEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.finish();
    }

    private final void onBarcodeFound(FirebaseVisionBarcode barcode, ImageProxy image) {
        Lifecycle lifecycle = this.getLifecycle();
        Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"lifecycle");
        if (lifecycle.getCurrentState() == Lifecycle.State.RESUMED) {
            this.updateViewsForScanSuccess(barcode, image);
            Handler handler = this.mainHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
            }
            handler.postDelayed(new Runnable(this, barcode){
                final /* synthetic */ BarcodePluginActivity this$0;
                final /* synthetic */ FirebaseVisionBarcode $barcode;

                public final void run() {
                    EventBus eventBus = BarcodePluginActivity.access$getEventBus$p(this.this$0);
                    BarcodeType barcodeType = BarcodeType.Companion.fromVisionBarcode(this.$barcode.getFormat());
                    String string = this.$barcode.getDisplayValue();
                    if (string == null) {
                        string = "";
                    }
                    eventBus.postSticky((Object)new SuccessfulScanEvent(new BarcodeScannerResult(barcodeType, string)));
                    BarcodePluginActivity.access$getMainHandler$p(this.this$0).postDelayed(BarcodePluginActivity.access$getEventMessageDeliveryCheckRunnable$p(this.this$0), 1000L);
                }
                {
                    this.this$0 = barcodePluginActivity;
                    this.$barcode = firebaseVisionBarcode;
                }
            }, 500L);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onBarcodeDetectFailed(Exception exception) {
        if (exception instanceof FirebaseMLException && exception.getMessage() != null) {
            String string = exception.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Please wait", (boolean)false, (int)2, null)) {
                ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.firebase_ml_loading_indicator);
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"firebase_ml_loading_indicator");
                progressBar.setVisibility(0);
                Handler handler = this.mainHandler;
                if (handler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
                }
                Handler handler2 = handler;
                boolean bl = false;
                boolean bl2 = false;
                Handler $this$apply = handler2;
                boolean bl3 = false;
                $this$apply.removeCallbacks(this.hideLoadingIndicatorRunnable);
                $this$apply.postDelayed(this.hideLoadingIndicatorRunnable, 1000L);
                return;
            }
        }
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.firebase_ml_loading_indicator);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"firebase_ml_loading_indicator");
        progressBar.setVisibility(8);
        this.scanFailed(BarcodeScannerFailureCode.UNKNOWN_REASON, exception);
    }

    private final void startScan() {
        Handler handler = this.mainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
        }
        handler.post(new Runnable(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void run() {
                try {
                    ((BarcodeScannerPreviewView)this.this$0._$_findCachedViewById(R.id.preview_view)).startScan((LifecycleOwner)this.this$0, BarcodePluginActivity.access$getBarcodeAnalyzer$p(this.this$0));
                    BarcodePluginActivity.access$updateViewsForStartScan(this.this$0);
                }
                catch (Exception exc) {
                    BarcodePluginActivity.access$scanFailed(this.this$0, BarcodeScannerFailureCode.UNKNOWN_REASON, exc);
                }
            }
            {
                this.this$0 = barcodePluginActivity;
            }
        });
    }

    private final void scanFailed(BarcodeScannerFailureCode code, Exception exception) {
        this.finish();
        this.eventBus.postSticky((Object)new FailedScanEvent(code, exception));
    }

    static /* synthetic */ void scanFailed$default(BarcodePluginActivity barcodePluginActivity, BarcodeScannerFailureCode barcodeScannerFailureCode, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            exception = null;
        }
        barcodePluginActivity.scanFailed(barcodeScannerFailureCode, exception);
    }

    private final void updateViewsForStartScan() {
        TextView textView = (TextView)this._$_findCachedViewById(R.id.status_text);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"status_text");
        BarcodeScannerOptions barcodeScannerOptions = this.barcodeScannerOptions;
        this.updateTextViewWithVisibilityCheck(textView, barcodeScannerOptions != null ? barcodeScannerOptions.getInstructionText() : null);
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.scanning_indicator);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"scanning_indicator");
        progressBar.setVisibility(0);
        ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.scan_success_indicator);
        Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"scan_success_indicator");
        imageView.setVisibility(8);
        BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView), (String)"focus_box");
        barcodeScannerFocusIndicatorView.setSelected(false);
        FrameLayout frameLayout = (FrameLayout)this._$_findCachedViewById(R.id.frozen_frame_wrapper);
        Intrinsics.checkExpressionValueIsNotNull((Object)frameLayout, (String)"frozen_frame_wrapper");
        frameLayout.setVisibility(8);
    }

    private final void updateViewsForScanSuccess(FirebaseVisionBarcode barcode, ImageProxy image) {
        block0: {
            TextView textView = (TextView)this._$_findCachedViewById(R.id.status_text);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"status_text");
            BarcodeScannerOptions barcodeScannerOptions = this.barcodeScannerOptions;
            this.updateTextViewWithVisibilityCheck(textView, barcodeScannerOptions != null ? barcodeScannerOptions.getSuccessText() : null);
            ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.scanning_indicator);
            Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"scanning_indicator");
            progressBar.setVisibility(8);
            ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.scan_success_indicator);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"scan_success_indicator");
            imageView.setVisibility(0);
            BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView), (String)"focus_box");
            barcodeScannerFocusIndicatorView.setSelected(true);
            Bitmap previewBitmap = Utils.INSTANCE.convertImageToBitmap(image);
            ((ImageView)this._$_findCachedViewById(R.id.frozen_frame)).setImageBitmap(previewBitmap);
            FrameLayout frameLayout = (FrameLayout)this._$_findCachedViewById(R.id.frozen_frame_wrapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)frameLayout, (String)"frozen_frame_wrapper");
            frameLayout.setVisibility(0);
            Rect rect = barcode.getBoundingBox();
            if (rect == null) break block0;
            Rect rect2 = rect;
            boolean bl = false;
            boolean bl2 = false;
            Rect $this$apply = rect2;
            boolean bl3 = false;
            Rect rect3 = $this$apply;
            Intrinsics.checkExpressionValueIsNotNull((Object)rect3, (String)"this");
            Rect bounds = UtilsKt.scaleRectBy(rect3, this.getPreviewToImageXRation(image), this.getPreviewToImageYRation(image));
            BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView2 = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView2), (String)"focus_box");
            int n = barcodeScannerFocusIndicatorView2.getLeft();
            BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView3 = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView3), (String)"focus_box");
            int focusBoxCenterX = n + barcodeScannerFocusIndicatorView3.getWidth() / 2;
            BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView4 = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView4), (String)"focus_box");
            int n2 = barcodeScannerFocusIndicatorView4.getTop();
            BarcodeScannerFocusIndicatorView barcodeScannerFocusIndicatorView5 = (BarcodeScannerFocusIndicatorView)this._$_findCachedViewById(R.id.focus_box);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)barcodeScannerFocusIndicatorView5), (String)"focus_box");
            int focusBoxCenterY = n2 + barcodeScannerFocusIndicatorView5.getHeight() / 2;
            int barcodeCenterX = (bounds.left + bounds.right) / 2;
            int barcodeCenterY = (bounds.top + bounds.bottom) / 2;
            ImageView imageView2 = (ImageView)this._$_findCachedViewById(R.id.frozen_frame);
            boolean bl4 = false;
            boolean bl5 = false;
            ImageView $this$apply2 = imageView2;
            boolean bl6 = false;
            $this$apply2.setTranslationX((float)(focusBoxCenterX - barcodeCenterX));
            $this$apply2.setTranslationY((float)(focusBoxCenterY - barcodeCenterY));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateTextViewWithVisibilityCheck(TextView view, String text) {
        String string = text;
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                view.setVisibility(0);
                view.setText((CharSequence)text);
                return;
            }
        }
        view.setVisibility(8);
    }

    /*
     * Unable to fully structure code
     */
    private final float getPreviewToImageXRation(ImageProxy image) {
        v0 = image.getImageInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"image.imageInfo");
        if (v0.getRotationDegrees() == 0) ** GOTO lbl-1000
        v1 = image.getImageInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"image.imageInfo");
        if (v1.getRotationDegrees() == 270) lbl-1000:
        // 2 sources

        {
            v2 = image.getWidth();
        } else {
            v2 = image.getHeight();
        }
        width = v2;
        v3 = (BarcodeScannerPreviewView)this._$_findCachedViewById(R.id.preview_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"preview_view");
        return (float)v3.getWidth() / (float)width;
    }

    /*
     * Unable to fully structure code
     */
    private final float getPreviewToImageYRation(ImageProxy image) {
        v0 = image.getImageInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"image.imageInfo");
        if (v0.getRotationDegrees() == 0) ** GOTO lbl-1000
        v1 = image.getImageInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"image.imageInfo");
        if (v1.getRotationDegrees() == 270) lbl-1000:
        // 2 sources

        {
            v2 = image.getHeight();
        } else {
            v2 = image.getWidth();
        }
        height = v2;
        v3 = (BarcodeScannerPreviewView)this._$_findCachedViewById(R.id.preview_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"preview_view");
        return (float)v3.getHeight() / (float)height;
    }

    public static final /* synthetic */ BarcodeAnalyzer access$getBarcodeAnalyzer$p(BarcodePluginActivity $this) {
        BarcodeAnalyzer barcodeAnalyzer = $this.barcodeAnalyzer;
        if (barcodeAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeAnalyzer");
        }
        return barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$setBarcodeAnalyzer$p(BarcodePluginActivity $this, BarcodeAnalyzer barcodeAnalyzer) {
        $this.barcodeAnalyzer = barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$onBarcodeFound(BarcodePluginActivity $this, FirebaseVisionBarcode barcode, ImageProxy image) {
        $this.onBarcodeFound(barcode, image);
    }

    public static final /* synthetic */ void access$onBarcodeDetectFailed(BarcodePluginActivity $this, Exception exception) {
        $this.onBarcodeDetectFailed(exception);
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(BarcodePluginActivity $this) {
        return $this.eventBus;
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(BarcodePluginActivity $this) {
        Handler handler = $this.mainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
        }
        return handler;
    }

    public static final /* synthetic */ void access$setMainHandler$p(BarcodePluginActivity $this, Handler handler) {
        $this.mainHandler = handler;
    }

    public static final /* synthetic */ Runnable access$getEventMessageDeliveryCheckRunnable$p(BarcodePluginActivity $this) {
        return $this.eventMessageDeliveryCheckRunnable;
    }

    public static final /* synthetic */ void access$updateViewsForStartScan(BarcodePluginActivity $this) {
        $this.updateViewsForStartScan();
    }

    public static final /* synthetic */ void access$scanFailed(BarcodePluginActivity $this, BarcodeScannerFailureCode code, Exception exception) {
        $this.scanFailed(code, exception);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity$Companion;", "", "()V", "ARTIFICIAL_PAUSE_IN_MS", "", "FIREBASE_ML_LOADING_TIME_THRESHOLD_IN_MS", "OPTIONS_VALUE", "", "SUCCESSFUL_SCAN_PROCESS_TIME_THRESHOLD_IN_MS", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "barcodeOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "barcodescanner_release"})
    public static final class Companion {
        @NotNull
        public final Intent getIntent(@NotNull Context context, @NotNull BarcodeScannerOptions barcodeOptions) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)barcodeOptions, (String)"barcodeOptions");
            Intent intent = new Intent(context, BarcodePluginActivity.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            Bundle bundle = new Bundle();
            Intent intent2 = $this$apply;
            boolean bl4 = false;
            boolean bl5 = false;
            Bundle $this$apply2 = bundle;
            boolean bl6 = false;
            $this$apply2.putSerializable(BarcodePluginActivity.OPTIONS_VALUE, (Serializable)barcodeOptions);
            Bundle bundle2 = bundle;
            intent2.putExtras(bundle2);
            $this$apply.setFlags(0x20000000);
            return intent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

