/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001e\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "Landroidx/lifecycle/LifecycleEventObserver;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "onBarcodeDetected", "Lkotlin/Function2;", "", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "Landroidx/camera/core/ImageProxy;", "", "onBarcodeDetectFailed", "Lkotlin/Function1;", "Ljava/lang/Exception;", "barcodeScannerOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "(Landroidx/appcompat/app/AppCompatActivity;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;)V", "detector", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "getDetector", "()Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "detector$delegate", "Lkotlin/Lazy;", "isPaused", "", "()Z", "setPaused", "(Z)V", "lastAnalyzedTimestamp", "", "analyze", "image", "closeImageProxy", "doAnalyze", "onStateChanged", "source", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "rotationDegreesToFirebaseRotation", "", "rotationDegrees", "barcodescanner_release"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer,
LifecycleEventObserver {
    private boolean isPaused;
    private long lastAnalyzedTimestamp;
    private final Lazy detector$delegate;
    private final AppCompatActivity activity;
    private final Function2<List<? extends FirebaseVisionBarcode>, ImageProxy, Unit> onBarcodeDetected;
    private final Function1<Exception, Unit> onBarcodeDetectFailed;
    private final BarcodeScannerOptions barcodeScannerOptions;

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    private final FirebaseVisionBarcodeDetector getDetector() {
        Lazy lazy = this.detector$delegate;
        BarcodeAnalyzer barcodeAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FirebaseVisionBarcodeDetector)lazy.getValue();
    }

    public void analyze(@NotNull ImageProxy image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        if (this.isPaused) {
            this.closeImageProxy(image);
        } else {
            this.doAnalyze(image);
        }
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event == Lifecycle.Event.ON_RESUME) {
            this.isPaused = false;
        }
    }

    private final void doAnalyze(ImageProxy image) {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.lastAnalyzedTimestamp >= TimeUnit.SECONDS.toMillis(1L)) {
            FirebaseVisionImageMetadata.Builder builder = new FirebaseVisionImageMetadata.Builder().setFormat(842094169).setHeight(image.getHeight()).setWidth(image.getWidth());
            ImageInfo imageInfo = image.getImageInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)imageInfo, (String)"image.imageInfo");
            FirebaseVisionImageMetadata firebaseVisionImageMetadata = builder.setRotation(this.rotationDegreesToFirebaseRotation(imageInfo.getRotationDegrees())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImageMetadata, (String)"FirebaseVisionImageMetad\u2026\n                .build()");
            FirebaseVisionImageMetadata metadata = firebaseVisionImageMetadata;
            ImageProxy.PlaneProxy planeProxy = image.getPlanes()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy, (String)"image.planes[0]");
            FirebaseVisionImage firebaseVisionImage = FirebaseVisionImage.fromByteBuffer((ByteBuffer)planeProxy.getBuffer(), (FirebaseVisionImageMetadata)metadata);
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImage, (String)"FirebaseVisionImage.from\u2026anes[0].buffer, metadata)");
            FirebaseVisionImage firebaseImage = firebaseVisionImage;
            this.getDetector().detectInImage(firebaseImage).addOnSuccessListener((Activity)this.activity, (OnSuccessListener)new OnSuccessListener<List<FirebaseVisionBarcode>>(this, image){
                final /* synthetic */ BarcodeAnalyzer this$0;
                final /* synthetic */ ImageProxy $image;

                public final void onSuccess(List<FirebaseVisionBarcode> it) {
                    if (!this.this$0.isPaused()) {
                        Function2 function2 = BarcodeAnalyzer.access$getOnBarcodeDetected$p(this.this$0);
                        List<FirebaseVisionBarcode> list = it;
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"it");
                        function2.invoke(list, (Object)this.$image);
                    }
                    BarcodeAnalyzer.access$closeImageProxy(this.this$0, this.$image);
                }
                {
                    this.this$0 = barcodeAnalyzer;
                    this.$image = imageProxy;
                }
            }).addOnFailureListener((Activity)this.activity, new OnFailureListener(this, image){
                final /* synthetic */ BarcodeAnalyzer this$0;
                final /* synthetic */ ImageProxy $image;

                public final void onFailure(@NotNull Exception it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (!this.this$0.isPaused()) {
                        BarcodeAnalyzer.access$getOnBarcodeDetectFailed$p(this.this$0).invoke((Object)it);
                    }
                    BarcodeAnalyzer.access$closeImageProxy(this.this$0, this.$image);
                }
                {
                    this.this$0 = barcodeAnalyzer;
                    this.$image = imageProxy;
                }
            });
        }
    }

    private final void closeImageProxy(ImageProxy image) {
        image.close();
    }

    private final int rotationDegreesToFirebaseRotation(int rotationDegrees) {
        int n;
        switch (rotationDegrees) {
            case 0: {
                n = 0;
                break;
            }
            case 90: {
                n = 1;
                break;
            }
            case 180: {
                n = 2;
                break;
            }
            case 270: {
                n = 3;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Not supported");
            }
        }
        return n;
    }

    public BarcodeAnalyzer(@NotNull AppCompatActivity activity, @NotNull Function2<? super List<? extends FirebaseVisionBarcode>, ? super ImageProxy, Unit> onBarcodeDetected, @NotNull Function1<? super Exception, Unit> onBarcodeDetectFailed, @Nullable BarcodeScannerOptions barcodeScannerOptions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(onBarcodeDetected, (String)"onBarcodeDetected");
        Intrinsics.checkParameterIsNotNull(onBarcodeDetectFailed, (String)"onBarcodeDetectFailed");
        this.activity = activity;
        this.onBarcodeDetected = onBarcodeDetected;
        this.onBarcodeDetectFailed = onBarcodeDetectFailed;
        this.barcodeScannerOptions = barcodeScannerOptions;
        this.activity.getLifecycle().addObserver((LifecycleObserver)this);
        this.detector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirebaseVisionBarcodeDetector>(this){
            final /* synthetic */ BarcodeAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirebaseVisionBarcodeDetector invoke() {
                FirebaseVisionBarcodeDetector firebaseVisionBarcodeDetector;
                if (BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0) == null) {
                    FirebaseVision firebaseVision = FirebaseVision.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
                    firebaseVisionBarcodeDetector = firebaseVision.getVisionBarcodeDetector();
                } else {
                    void $this$fold$iv;
                    Iterable iterable = BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0).getBarcodeTypes();
                    int initial$iv = 0;
                    boolean $i$f$fold = false;
                    int accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void barcodeType;
                        BarcodeType barcodeType2 = (BarcodeType)((Object)element$iv);
                        int sum = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = sum | barcodeType.toVisionBarcodeType();
                    }
                    int combinedType = accumulator$iv;
                    FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions = new FirebaseVisionBarcodeDetectorOptions.Builder().setBarcodeFormats(combinedType, new int[0]).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionBarcodeDetectorOptions, (String)"FirebaseVisionBarcodeDet\u2026                 .build()");
                    FirebaseVisionBarcodeDetectorOptions options = firebaseVisionBarcodeDetectorOptions;
                    firebaseVisionBarcodeDetector = FirebaseVision.getInstance().getVisionBarcodeDetector(options);
                }
                return firebaseVisionBarcodeDetector;
            }
            {
                this.this$0 = barcodeAnalyzer;
                super(0);
            }
        }));
    }

    public /* synthetic */ BarcodeAnalyzer(AppCompatActivity appCompatActivity, Function2 function2, Function1 function1, BarcodeScannerOptions barcodeScannerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            barcodeScannerOptions = null;
        }
        this(appCompatActivity, (Function2<? super List<? extends FirebaseVisionBarcode>, ? super ImageProxy, Unit>)function2, (Function1<? super Exception, Unit>)function1, barcodeScannerOptions);
    }

    public static final /* synthetic */ Function2 access$getOnBarcodeDetected$p(BarcodeAnalyzer $this) {
        return $this.onBarcodeDetected;
    }

    public static final /* synthetic */ void access$closeImageProxy(BarcodeAnalyzer $this, ImageProxy image) {
        $this.closeImageProxy(image);
    }

    public static final /* synthetic */ Function1 access$getOnBarcodeDetectFailed$p(BarcodeAnalyzer $this) {
        return $this.onBarcodeDetectFailed;
    }

    public static final /* synthetic */ BarcodeScannerOptions access$getBarcodeScannerOptions$p(BarcodeAnalyzer $this) {
        return $this.barcodeScannerOptions;
    }
}

