/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.salesforce.barcodescannerplugin.BarcodeAnalyzer;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.barcodescannerplugin.BarcodeType;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.events.ScanStartedEvent;
import com.salesforce.barcodescannerplugin.events.StopScanEvent;
import com.salesforce.barcodescannerplugin.events.SuccessfulScanEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020\u001cH\u0014J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010'\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J-\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00162\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00101R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "barcodeAnalyzer", "Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "camera", "Landroidx/camera/core/Camera;", "cameraProviderFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "eventBus", "Lorg/greenrobot/eventbus/EventBus;", "kotlin.jvm.PlatformType", "executor", "Ljava/util/concurrent/ExecutorService;", "imageAnalysis", "Landroidx/camera/core/ImageAnalysis;", "preview", "Landroidx/camera/core/Preview;", "viewFinder", "Landroidx/camera/view/PreviewView;", "getAspectRation", "", "width", "height", "getIntentBarcodeScannerOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "initializeCamera", "", "onBarcodeFound", "barcode", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onMessage", "event", "Lcom/salesforce/barcodescannerplugin/events/StopScanEvent;", "onNewIntent", "intent", "Landroid/content/Intent;", "onRequestPermissionsResult", "requestCode", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "barcodescanner_release"})
public final class BarcodePluginActivity
extends AppCompatActivity {
    private ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    private PreviewView viewFinder;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final EventBus eventBus = EventBus.getDefault();
    private BarcodeAnalyzer barcodeAnalyzer;
    private Preview preview;
    private ImageAnalysis imageAnalysis;
    private Camera camera;
    private static final String TAG = "BarcodePluginActivity";
    @NotNull
    public static final String OPTIONS_VALUE = "OptionsValue";
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.barcode_plugin_activity);
        View view = this.findViewById(R.id.preview_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.preview_view)");
        this.viewFinder = (PreviewView)view;
        this.barcodeAnalyzer = new BarcodeAnalyzer((Function1<? super List<? extends FirebaseVisionBarcode>, Unit>)((Function1)new Function1<List<? extends FirebaseVisionBarcode>, Unit>(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void invoke(@NotNull List<? extends FirebaseVisionBarcode> qrCodes) {
                Intrinsics.checkParameterIsNotNull(qrCodes, (String)"qrCodes");
                Collection collection = qrCodes;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    BarcodePluginActivity.access$getBarcodeAnalyzer$p(this.this$0).setPaused(true);
                    FirebaseVisionBarcode barcode = (FirebaseVisionBarcode)CollectionsKt.first(qrCodes);
                    BarcodePluginActivity.access$onBarcodeFound(this.this$0, barcode);
                }
            }
            {
                this.this$0 = barcodePluginActivity;
                super(1);
            }
        }), this.getIntentBarcodeScannerOptions());
        if (!Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            Utils.INSTANCE.requestPermissions((Activity)this);
        } else {
            PreviewView previewView = this.viewFinder;
            if (previewView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
            }
            previewView.post(new Runnable(this){
                final /* synthetic */ BarcodePluginActivity this$0;

                public final void run() {
                    BarcodePluginActivity.access$initializeCamera(this.this$0);
                }
                {
                    this.this$0 = barcodePluginActivity;
                }
            });
        }
        this.eventBus.register((Object)this);
        this.eventBus.post((Object)new ScanStartedEvent());
    }

    protected void onNewIntent(@Nullable Intent intent) {
        block1: {
            super.onNewIntent(intent);
            BarcodeAnalyzer barcodeAnalyzer = this.barcodeAnalyzer;
            if (barcodeAnalyzer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeAnalyzer");
            }
            if (barcodeAnalyzer == null) break block1;
            barcodeAnalyzer.setPaused(false);
        }
    }

    protected void onDestroy() {
        ImageAnalysis imageAnalysis = this.imageAnalysis;
        if (imageAnalysis != null) {
            imageAnalysis.clearAnalyzer();
        }
        this.imageAnalysis = null;
        this.camera = null;
        this.executor.shutdown();
        this.eventBus.unregister((Object)this);
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            PreviewView previewView = this.viewFinder;
            if (previewView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
            }
            previewView.post(new Runnable(this){
                final /* synthetic */ BarcodePluginActivity this$0;

                public final void run() {
                    BarcodePluginActivity.access$initializeCamera(this.this$0);
                }
                {
                    this.this$0 = barcodePluginActivity;
                }
            });
        }
    }

    @Subscribe
    public final void onMessage(@NotNull StopScanEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.finish();
    }

    private final int getAspectRation(int width, int height) {
        boolean bl = false;
        double d = Math.max(width, height);
        bl = false;
        int n = Math.min(width, height);
        double previewRatio = d / (double)n;
        double d2 = previewRatio - 1.3333333333333333;
        boolean bl2 = false;
        double d3 = Math.abs(d2);
        d2 = previewRatio - 1.7777777777777777;
        d = d3;
        bl2 = false;
        double d4 = Math.abs(d2);
        return d <= d4 ? 0 : 1;
    }

    private final void initializeCamera() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        boolean bl = false;
        boolean bl2 = false;
        DisplayMetrics it = displayMetrics;
        boolean bl3 = false;
        PreviewView previewView = this.viewFinder;
        if (previewView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        previewView.getDisplay().getRealMetrics(it);
        DisplayMetrics metrics = displayMetrics;
        PreviewView previewView2 = this.viewFinder;
        if (previewView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        Display display = previewView2.getDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"viewFinder.display");
        int rotation = display.getRotation();
        int screenAspectRatio = this.getAspectRation(metrics.widthPixels, metrics.heightPixels);
        Intrinsics.checkExpressionValueIsNotNull((Object)((ImageView)this._$_findCachedViewById(R.id.barcode_frame)), (String)"barcode_frame");
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).getLayoutParams().height = metrics.heightPixels / 2;
        Intrinsics.checkExpressionValueIsNotNull((Object)((ImageView)this._$_findCachedViewById(R.id.barcode_frame)), (String)"barcode_frame");
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).getLayoutParams().width = metrics.widthPixels / 2;
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).requestLayout();
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)((Context)this));
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"ProcessCameraProvider.getInstance(this)");
        this.cameraProviderFuture = listenableFuture;
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026LENS_FACING_BACK).build()");
        CameraSelector cameraSelector2 = cameraSelector;
        ListenableFuture<ProcessCameraProvider> listenableFuture2 = this.cameraProviderFuture;
        if (listenableFuture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraProviderFuture");
        }
        listenableFuture2.addListener(new Runnable(this, screenAspectRatio, rotation, cameraSelector2){
            final /* synthetic */ BarcodePluginActivity this$0;
            final /* synthetic */ int $screenAspectRatio;
            final /* synthetic */ int $rotation;
            final /* synthetic */ CameraSelector $cameraSelector;

            public final void run() {
                ProcessCameraProvider cameraProvider = (ProcessCameraProvider)BarcodePluginActivity.access$getCameraProviderFuture$p(this.this$0).get();
                Preview.Builder builder = new Preview.Builder();
                BarcodePluginActivity barcodePluginActivity = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Preview.Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.setTargetAspectRatio(this.$screenAspectRatio);
                $this$apply.setTargetRotation(this.$rotation);
                Preview.Builder builder2 = builder;
                BarcodePluginActivity.access$setPreview$p(barcodePluginActivity, builder2.build());
                BarcodePluginActivity.access$getViewFinder$p(this.this$0).setPreferredImplementationMode(PreviewView.ImplementationMode.TEXTURE_VIEW);
                Preview preview = BarcodePluginActivity.access$getPreview$p(this.this$0);
                if (preview != null) {
                    Camera camera = BarcodePluginActivity.access$getCamera$p(this.this$0);
                    preview.setSurfaceProvider(BarcodePluginActivity.access$getViewFinder$p(this.this$0).createSurfaceProvider((CameraInfo)(camera != null ? camera.getCameraInfo() : null)));
                }
                builder = new ImageAnalysis.Builder().setTargetAspectRatio(this.$screenAspectRatio).setBackpressureStrategy(0).setImageQueueDepth(0).setTargetRotation(this.$rotation).build();
                barcodePluginActivity = this.this$0;
                bl = false;
                bl2 = false;
                Preview.Builder it = builder;
                boolean bl4 = false;
                it.setAnalyzer((Executor)BarcodePluginActivity.access$getExecutor$p(this.this$0), (ImageAnalysis.Analyzer)BarcodePluginActivity.access$getBarcodeAnalyzer$p(this.this$0));
                builder2 = builder;
                BarcodePluginActivity.access$setImageAnalysis$p(barcodePluginActivity, (ImageAnalysis)builder2);
                cameraProvider.unbindAll();
                try {
                    BarcodePluginActivity.access$setCamera$p(this.this$0, cameraProvider.bindToLifecycle((LifecycleOwner)this.this$0, this.$cameraSelector, new UseCase[]{(UseCase)BarcodePluginActivity.access$getPreview$p(this.this$0), (UseCase)BarcodePluginActivity.access$getImageAnalysis$p(this.this$0)}));
                }
                catch (Exception exc) {
                    Utils.INSTANCE.postError("BarcodePluginActivity", "Failed to start camera", exc);
                }
            }
            {
                this.this$0 = barcodePluginActivity;
                this.$screenAspectRatio = n;
                this.$rotation = n2;
                this.$cameraSelector = cameraSelector;
            }
        }, ContextCompat.getMainExecutor((Context)((Context)this)));
        ((AppCompatImageButton)this._$_findCachedViewById(R.id.close_button)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void onClick(View it) {
                this.this$0.onBackPressed();
            }
            {
                this.this$0 = barcodePluginActivity;
            }
        });
    }

    private final BarcodeScannerOptions getIntentBarcodeScannerOptions() {
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        return (BarcodeScannerOptions)(bundle != null ? bundle.getSerializable(OPTIONS_VALUE) : null);
    }

    private final void onBarcodeFound(FirebaseVisionBarcode barcode) {
        Lifecycle lifecycle = this.getLifecycle();
        Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"lifecycle");
        if (lifecycle.getCurrentState() == Lifecycle.State.RESUMED) {
            BarcodeType barcodeType = BarcodeType.Companion.fromVisionBarcode(barcode.getFormat());
            String string = barcode.getDisplayValue();
            if (string == null) {
                string = "";
            }
            this.eventBus.postSticky((Object)new SuccessfulScanEvent(new BarcodeScannerResult(barcodeType, string)));
        }
    }

    public static final /* synthetic */ BarcodeAnalyzer access$getBarcodeAnalyzer$p(BarcodePluginActivity $this) {
        BarcodeAnalyzer barcodeAnalyzer = $this.barcodeAnalyzer;
        if (barcodeAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeAnalyzer");
        }
        return barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$setBarcodeAnalyzer$p(BarcodePluginActivity $this, BarcodeAnalyzer barcodeAnalyzer) {
        $this.barcodeAnalyzer = barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$onBarcodeFound(BarcodePluginActivity $this, FirebaseVisionBarcode barcode) {
        $this.onBarcodeFound(barcode);
    }

    public static final /* synthetic */ void access$initializeCamera(BarcodePluginActivity $this) {
        $this.initializeCamera();
    }

    public static final /* synthetic */ ListenableFuture access$getCameraProviderFuture$p(BarcodePluginActivity $this) {
        ListenableFuture<ProcessCameraProvider> listenableFuture = $this.cameraProviderFuture;
        if (listenableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraProviderFuture");
        }
        return listenableFuture;
    }

    public static final /* synthetic */ void access$setCameraProviderFuture$p(BarcodePluginActivity $this, ListenableFuture listenableFuture) {
        $this.cameraProviderFuture = listenableFuture;
    }

    public static final /* synthetic */ Preview access$getPreview$p(BarcodePluginActivity $this) {
        return $this.preview;
    }

    public static final /* synthetic */ void access$setPreview$p(BarcodePluginActivity $this, Preview preview) {
        $this.preview = preview;
    }

    public static final /* synthetic */ PreviewView access$getViewFinder$p(BarcodePluginActivity $this) {
        PreviewView previewView = $this.viewFinder;
        if (previewView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        return previewView;
    }

    public static final /* synthetic */ void access$setViewFinder$p(BarcodePluginActivity $this, PreviewView previewView) {
        $this.viewFinder = previewView;
    }

    public static final /* synthetic */ Camera access$getCamera$p(BarcodePluginActivity $this) {
        return $this.camera;
    }

    public static final /* synthetic */ void access$setCamera$p(BarcodePluginActivity $this, Camera camera) {
        $this.camera = camera;
    }

    public static final /* synthetic */ ImageAnalysis access$getImageAnalysis$p(BarcodePluginActivity $this) {
        return $this.imageAnalysis;
    }

    public static final /* synthetic */ void access$setImageAnalysis$p(BarcodePluginActivity $this, ImageAnalysis imageAnalysis) {
        $this.imageAnalysis = imageAnalysis;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(BarcodePluginActivity $this) {
        return $this.executor;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity$Companion;", "", "()V", "OPTIONS_VALUE", "", "RATIO_16_9_VALUE", "", "RATIO_4_3_VALUE", "TAG", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "barcodeOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "barcodescanner_release"})
    public static final class Companion {
        @NotNull
        public final Intent getIntent(@NotNull Context context, @NotNull BarcodeScannerOptions barcodeOptions) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)barcodeOptions, (String)"barcodeOptions");
            Intent intent = new Intent(context, BarcodePluginActivity.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            Bundle bundle = new Bundle();
            Intent intent2 = $this$apply;
            boolean bl4 = false;
            boolean bl5 = false;
            Bundle $this$apply2 = bundle;
            boolean bl6 = false;
            $this$apply2.putSerializable(BarcodePluginActivity.OPTIONS_VALUE, (Serializable)barcodeOptions);
            Bundle bundle2 = bundle;
            intent2.putExtras(bundle2);
            $this$apply.setFlags(0x20000000);
            return intent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

