/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeType;
import com.salesforce.barcodescannerplugin.Utils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB+\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "onBarcodeDetected", "Lkotlin/Function1;", "", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "", "barcodeScannerOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "(Lkotlin/jvm/functions/Function1;Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;)V", "detector", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "getDetector", "()Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "detector$delegate", "Lkotlin/Lazy;", "isPaused", "", "()Z", "setPaused", "(Z)V", "lastAnalyzedTimestamp", "", "analyze", "image", "Landroidx/camera/core/ImageProxy;", "closeImageProxy", "doAnalyze", "rotationDegreesToFirebaseRotation", "", "rotationDegrees", "Companion", "barcodescanner_release"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    private long lastAnalyzedTimestamp;
    private final Lazy detector$delegate;
    private boolean isPaused;
    private final Function1<List<? extends FirebaseVisionBarcode>, Unit> onBarcodeDetected;
    private final BarcodeScannerOptions barcodeScannerOptions;
    @NotNull
    public static final String TAG = "BarcodeAnalyzer";
    public static final Companion Companion = new Companion(null);

    private final FirebaseVisionBarcodeDetector getDetector() {
        Lazy lazy = this.detector$delegate;
        BarcodeAnalyzer barcodeAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FirebaseVisionBarcodeDetector)lazy.getValue();
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public void analyze(@NotNull ImageProxy image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        if (this.isPaused) {
            this.closeImageProxy(image);
        } else {
            this.doAnalyze(image);
        }
    }

    private final void doAnalyze(ImageProxy image) {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.lastAnalyzedTimestamp >= TimeUnit.SECONDS.toMillis(1L)) {
            FirebaseVisionImageMetadata.Builder builder = new FirebaseVisionImageMetadata.Builder().setFormat(842094169).setHeight(image.getHeight()).setWidth(image.getWidth());
            ImageInfo imageInfo = image.getImageInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)imageInfo, (String)"image.imageInfo");
            FirebaseVisionImageMetadata firebaseVisionImageMetadata = builder.setRotation(this.rotationDegreesToFirebaseRotation(imageInfo.getRotationDegrees())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImageMetadata, (String)"FirebaseVisionImageMetad\u2026\n                .build()");
            FirebaseVisionImageMetadata metadata = firebaseVisionImageMetadata;
            ImageProxy.PlaneProxy planeProxy = image.getPlanes()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy, (String)"image.planes[0]");
            FirebaseVisionImage firebaseVisionImage = FirebaseVisionImage.fromByteBuffer((ByteBuffer)planeProxy.getBuffer(), (FirebaseVisionImageMetadata)metadata);
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImage, (String)"FirebaseVisionImage.from\u2026anes[0].buffer, metadata)");
            FirebaseVisionImage firebaseImage = firebaseVisionImage;
            this.getDetector().detectInImage(firebaseImage).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<FirebaseVisionBarcode>>(this, image){
                final /* synthetic */ BarcodeAnalyzer this$0;
                final /* synthetic */ ImageProxy $image;

                public final void onSuccess(List<FirebaseVisionBarcode> it) {
                    if (!this.this$0.isPaused()) {
                        Function1 function1 = BarcodeAnalyzer.access$getOnBarcodeDetected$p(this.this$0);
                        List<FirebaseVisionBarcode> list = it;
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"it");
                        function1.invoke(list);
                    }
                    BarcodeAnalyzer.access$closeImageProxy(this.this$0, this.$image);
                }
                {
                    this.this$0 = barcodeAnalyzer;
                    this.$image = imageProxy;
                }
            }).addOnFailureListener(new OnFailureListener(this, image){
                final /* synthetic */ BarcodeAnalyzer this$0;
                final /* synthetic */ ImageProxy $image;

                public final void onFailure(@NotNull Exception it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (!this.this$0.isPaused()) {
                        Utils.INSTANCE.postError("BarcodeAnalyzer", "Failed to scan barcode", it);
                    }
                    BarcodeAnalyzer.access$closeImageProxy(this.this$0, this.$image);
                }
                {
                    this.this$0 = barcodeAnalyzer;
                    this.$image = imageProxy;
                }
            });
        }
    }

    private final void closeImageProxy(ImageProxy image) {
        image.close();
    }

    private final int rotationDegreesToFirebaseRotation(int rotationDegrees) {
        int n;
        switch (rotationDegrees) {
            case 0: {
                n = 0;
                break;
            }
            case 90: {
                n = 1;
                break;
            }
            case 180: {
                n = 2;
                break;
            }
            case 270: {
                n = 3;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Not supported");
            }
        }
        return n;
    }

    public BarcodeAnalyzer(@NotNull Function1<? super List<? extends FirebaseVisionBarcode>, Unit> onBarcodeDetected, @Nullable BarcodeScannerOptions barcodeScannerOptions) {
        Intrinsics.checkParameterIsNotNull(onBarcodeDetected, (String)"onBarcodeDetected");
        this.onBarcodeDetected = onBarcodeDetected;
        this.barcodeScannerOptions = barcodeScannerOptions;
        this.detector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirebaseVisionBarcodeDetector>(this){
            final /* synthetic */ BarcodeAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirebaseVisionBarcodeDetector invoke() {
                FirebaseVisionBarcodeDetector firebaseVisionBarcodeDetector;
                if (BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0) == null) {
                    FirebaseVision firebaseVision = FirebaseVision.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
                    firebaseVisionBarcodeDetector = firebaseVision.getVisionBarcodeDetector();
                } else {
                    void $this$fold$iv;
                    Iterable iterable = BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0).getBarcodeTypes();
                    int initial$iv = 0;
                    boolean $i$f$fold = false;
                    int accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void barcodeType;
                        BarcodeType barcodeType2 = (BarcodeType)((Object)element$iv);
                        int sum = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = sum | barcodeType.toVisionBarcodeType();
                    }
                    int combinedType = accumulator$iv;
                    FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions = new FirebaseVisionBarcodeDetectorOptions.Builder().setBarcodeFormats(combinedType, new int[0]).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionBarcodeDetectorOptions, (String)"FirebaseVisionBarcodeDet\u2026                 .build()");
                    FirebaseVisionBarcodeDetectorOptions options = firebaseVisionBarcodeDetectorOptions;
                    firebaseVisionBarcodeDetector = FirebaseVision.getInstance().getVisionBarcodeDetector(options);
                }
                return firebaseVisionBarcodeDetector;
            }
            {
                this.this$0 = barcodeAnalyzer;
                super(0);
            }
        }));
    }

    public /* synthetic */ BarcodeAnalyzer(Function1 function1, BarcodeScannerOptions barcodeScannerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            barcodeScannerOptions = null;
        }
        this((Function1<? super List<? extends FirebaseVisionBarcode>, Unit>)function1, barcodeScannerOptions);
    }

    public static final /* synthetic */ Function1 access$getOnBarcodeDetected$p(BarcodeAnalyzer $this) {
        return $this.onBarcodeDetected;
    }

    public static final /* synthetic */ void access$closeImageProxy(BarcodeAnalyzer $this, ImageProxy image) {
        $this.closeImageProxy(image);
    }

    public static final /* synthetic */ BarcodeScannerOptions access$getBarcodeScannerOptions$p(BarcodeAnalyzer $this) {
        return $this.barcodeScannerOptions;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer$Companion;", "", "()V", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

