/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.salesforce.barcodescannerplugin.BarcodeErrorEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/salesforce/barcodescannerplugin/Utils;", "", "()V", "REQUIRED_PERMISSION", "", "arePermissionsGranted", "", "activity", "Landroid/app/Activity;", "postError", "", "sourceClass", "errorMessage", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "requestPermissions", "barcodescanner_release"})
public final class Utils {
    private static final String REQUIRED_PERMISSION = "android.permission.CAMERA";
    public static final Utils INSTANCE;

    public final boolean arePermissionsGranted(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        return ContextCompat.checkSelfPermission((Context)((Context)activity), (String)REQUIRED_PERMISSION) == 0;
    }

    public final void requestPermissions(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{REQUIRED_PERMISSION}, (int)0);
    }

    public final void postError(@NotNull String sourceClass, @NotNull String errorMessage, @NotNull Exception error) {
        Intrinsics.checkParameterIsNotNull((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Log.e((String)sourceClass, (String)errorMessage, (Throwable)error);
        EventBus.getDefault().postSticky((Object)new BarcodeErrorEvent(errorMessage + ": " + error.getMessage()));
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

