/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.salesforce.barcodescannerplugin.BarcodeAnalyzer;
import com.salesforce.barcodescannerplugin.BarcodeAnalyzer$sam$com_google_android_gms_tasks_OnSuccessListener$0;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "onBarcodeDetected", "Lkotlin/Function1;", "", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "", "barcodeScannerOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "(Lkotlin/jvm/functions/Function1;Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;)V", "detector", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "getDetector", "()Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "detector$delegate", "Lkotlin/Lazy;", "lastAnalyzedTimestamp", "", "analyze", "image", "Landroidx/camera/core/ImageProxy;", "rotationDegreesToFirebaseRotation", "", "rotationDegrees", "Companion", "barcodescanner_release"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    private long lastAnalyzedTimestamp;
    private final Lazy detector$delegate;
    private final Function1<List<? extends FirebaseVisionBarcode>, Unit> onBarcodeDetected;
    private final BarcodeScannerOptions barcodeScannerOptions;
    @NotNull
    private static final String TAG = "BarcodeAnalyzer";
    public static final Companion Companion = new Companion(null);

    private final FirebaseVisionBarcodeDetector getDetector() {
        Lazy lazy = this.detector$delegate;
        BarcodeAnalyzer barcodeAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FirebaseVisionBarcodeDetector)lazy.getValue();
    }

    public void analyze(@NotNull ImageProxy image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.lastAnalyzedTimestamp >= TimeUnit.SECONDS.toMillis(1L)) {
            FirebaseVisionImageMetadata.Builder builder = new FirebaseVisionImageMetadata.Builder().setFormat(842094169).setHeight(image.getHeight()).setWidth(image.getWidth());
            ImageInfo imageInfo = image.getImageInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)imageInfo, (String)"image.imageInfo");
            FirebaseVisionImageMetadata firebaseVisionImageMetadata = builder.setRotation(this.rotationDegreesToFirebaseRotation(imageInfo.getRotationDegrees())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImageMetadata, (String)"FirebaseVisionImageMetad\u2026\n                .build()");
            FirebaseVisionImageMetadata metadata = firebaseVisionImageMetadata;
            ImageProxy.PlaneProxy planeProxy = image.getPlanes()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy, (String)"image.planes[0]");
            FirebaseVisionImage firebaseVisionImage = FirebaseVisionImage.fromByteBuffer((ByteBuffer)planeProxy.getBuffer(), (FirebaseVisionImageMetadata)metadata);
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionImage, (String)"FirebaseVisionImage.from\u2026anes[0].buffer, metadata)");
            FirebaseVisionImage firebaseImage = firebaseVisionImage;
            Task task = this.getDetector().detectInImage(firebaseImage);
            Object object = this.onBarcodeDetected;
            if (object != null) {
                Function1<List<? extends FirebaseVisionBarcode>, Unit> function1 = object;
                object = new BarcodeAnalyzer$sam$com_google_android_gms_tasks_OnSuccessListener$0(function1);
            }
            task.addOnSuccessListener((OnSuccessListener)object).addOnFailureListener((OnFailureListener)analyze.1.INSTANCE);
        }
        image.close();
    }

    private final int rotationDegreesToFirebaseRotation(int rotationDegrees) {
        int n;
        switch (rotationDegrees) {
            case 0: {
                n = 0;
                break;
            }
            case 90: {
                n = 1;
                break;
            }
            case 180: {
                n = 2;
                break;
            }
            case 270: {
                n = 3;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Not supported");
            }
        }
        return n;
    }

    public BarcodeAnalyzer(@NotNull Function1<? super List<? extends FirebaseVisionBarcode>, Unit> onBarcodeDetected, @Nullable BarcodeScannerOptions barcodeScannerOptions) {
        Intrinsics.checkParameterIsNotNull(onBarcodeDetected, (String)"onBarcodeDetected");
        this.onBarcodeDetected = onBarcodeDetected;
        this.barcodeScannerOptions = barcodeScannerOptions;
        this.detector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirebaseVisionBarcodeDetector>(this){
            final /* synthetic */ BarcodeAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirebaseVisionBarcodeDetector invoke() {
                FirebaseVisionBarcodeDetector firebaseVisionBarcodeDetector;
                if (BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0) == null) {
                    FirebaseVision firebaseVision = FirebaseVision.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
                    firebaseVisionBarcodeDetector = firebaseVision.getVisionBarcodeDetector();
                } else {
                    void $this$fold$iv;
                    Iterable iterable = BarcodeAnalyzer.access$getBarcodeScannerOptions$p(this.this$0).getBarcodeTypes();
                    int initial$iv = 0;
                    boolean $i$f$fold = false;
                    int accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void barcodeType;
                        BarcodeType barcodeType2 = (BarcodeType)((Object)element$iv);
                        int sum = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = sum | barcodeType.toVisionBarcodeType();
                    }
                    int combinedType = accumulator$iv;
                    FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions = new FirebaseVisionBarcodeDetectorOptions.Builder().setBarcodeFormats(combinedType, new int[0]).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionBarcodeDetectorOptions, (String)"FirebaseVisionBarcodeDet\u2026                 .build()");
                    FirebaseVisionBarcodeDetectorOptions options = firebaseVisionBarcodeDetectorOptions;
                    firebaseVisionBarcodeDetector = FirebaseVision.getInstance().getVisionBarcodeDetector(options);
                }
                return firebaseVisionBarcodeDetector;
            }
            {
                this.this$0 = barcodeAnalyzer;
                super(0);
            }
        }));
    }

    public /* synthetic */ BarcodeAnalyzer(Function1 function1, BarcodeScannerOptions barcodeScannerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            barcodeScannerOptions = null;
        }
        this((Function1<? super List<? extends FirebaseVisionBarcode>, Unit>)function1, barcodeScannerOptions);
    }

    static {
        TAG = TAG;
    }

    public static final /* synthetic */ BarcodeScannerOptions access$getBarcodeScannerOptions$p(BarcodeAnalyzer $this) {
        return $this.barcodeScannerOptions;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "barcodescanner_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

