/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.google.android.material.chip.Chip;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.barcodescannerplugin.BarcodeType;
import com.salesforce.barcodescannerplugin.LiveBarcodeScanningActivity$WhenMappings;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.barcodedetection.BarcodeProcessor;
import com.salesforce.barcodescannerplugin.barcodedetection.BarcodeScannedEvent;
import com.salesforce.barcodescannerplugin.camera.CameraSource;
import com.salesforce.barcodescannerplugin.camera.CameraSourcePreview;
import com.salesforce.barcodescannerplugin.camera.GraphicOverlay;
import com.salesforce.barcodescannerplugin.camera.WorkflowModel;
import java.io.IOException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/salesforce/barcodescannerplugin/LiveBarcodeScanningActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "barcodeDetectorOptions", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetectorOptions;", "cameraSource", "Lcom/salesforce/barcodescannerplugin/camera/CameraSource;", "currentWorkflowState", "Lcom/salesforce/barcodescannerplugin/camera/WorkflowModel$WorkflowState;", "graphicOverlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "preview", "Lcom/salesforce/barcodescannerplugin/camera/CameraSourcePreview;", "promptChip", "Lcom/google/android/material/chip/Chip;", "promptChipAnimator", "Landroid/animation/AnimatorSet;", "workflowModel", "Lcom/salesforce/barcodescannerplugin/camera/WorkflowModel;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onResume", "setUpWorkflowModel", "startCameraPreview", "stopCameraPreview", "Companion", "barcodescanner_release"})
public final class LiveBarcodeScanningActivity
extends AppCompatActivity {
    private CameraSource cameraSource;
    private CameraSourcePreview preview;
    private GraphicOverlay graphicOverlay;
    private Chip promptChip;
    private AnimatorSet promptChipAnimator;
    private WorkflowModel workflowModel;
    private WorkflowModel.WorkflowState currentWorkflowState;
    private FirebaseVisionBarcodeDetectorOptions barcodeDetectorOptions;
    private static final String TAG = "LiveBarcodeActivity";
    @NotNull
    public static final String OPTIONS_VALUE = "OptionsValue";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    /*
     * WARNING - void declaration
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        BarcodeScannerOptions barcodeScannerOptions = (BarcodeScannerOptions)(bundle != null ? bundle.getSerializable(OPTIONS_VALUE) : null);
        if (barcodeScannerOptions != null) {
            void $this$fold$iv;
            Iterable iterable = barcodeScannerOptions.getBarcodeTypes();
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void barcodeType;
                BarcodeType barcodeType2 = (BarcodeType)((Object)element$iv);
                int sum = accumulator$iv;
                boolean bl = false;
                accumulator$iv = sum | barcodeType.toVisionBarcodeType();
            }
            int combinedType = accumulator$iv;
            this.barcodeDetectorOptions = new FirebaseVisionBarcodeDetectorOptions.Builder().setBarcodeFormats(combinedType, new int[0]).build();
        }
        this.setContentView(R.layout.activity_live_barcode);
        this.preview = (CameraSourcePreview)this.findViewById(R.id.camera_preview);
        View view = this.findViewById(R.id.camera_preview_graphic_overlay);
        LiveBarcodeScanningActivity liveBarcodeScanningActivity = this;
        boolean bl = false;
        boolean bl2 = false;
        GraphicOverlay $this$apply = (GraphicOverlay)view;
        boolean bl3 = false;
        GraphicOverlay graphicOverlay = $this$apply;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)graphicOverlay), (String)"this");
        this.cameraSource = new CameraSource(graphicOverlay);
        View view2 = view;
        liveBarcodeScanningActivity.graphicOverlay = (GraphicOverlay)view2;
        this.promptChip = (Chip)this.findViewById(R.id.bottom_prompt_chip);
        Animator animator2 = AnimatorInflater.loadAnimator((Context)((Context)this), (int)R.animator.bottom_prompt_chip_enter);
        if (animator2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.animation.AnimatorSet");
        }
        view = (AnimatorSet)animator2;
        liveBarcodeScanningActivity = this;
        bl = false;
        bl2 = false;
        $this$apply = view;
        boolean bl4 = false;
        $this$apply.setTarget(this.promptChip);
        view2 = view;
        liveBarcodeScanningActivity.promptChipAnimator = view2;
        ((ImageView)this._$_findCachedViewById(R.id.close_button)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ LiveBarcodeScanningActivity this$0;

            public final void onClick(View it) {
                this.this$0.onBackPressed();
            }
            {
                this.this$0 = liveBarcodeScanningActivity;
            }
        });
        this.setUpWorkflowModel();
    }

    protected void onResume() {
        block4: {
            super.onResume();
            WorkflowModel workflowModel = this.workflowModel;
            if (workflowModel != null) {
                workflowModel.markCameraFrozen();
            }
            this.currentWorkflowState = WorkflowModel.WorkflowState.NOT_STARTED;
            CameraSource cameraSource = this.cameraSource;
            if (cameraSource != null) {
                GraphicOverlay graphicOverlay = this.graphicOverlay;
                if (graphicOverlay == null) {
                    Intrinsics.throwNpe();
                }
                WorkflowModel workflowModel2 = this.workflowModel;
                if (workflowModel2 == null) {
                    Intrinsics.throwNpe();
                }
                cameraSource.setFrameProcessor(new BarcodeProcessor(graphicOverlay, workflowModel2, this.barcodeDetectorOptions));
            }
            WorkflowModel workflowModel3 = this.workflowModel;
            if (workflowModel3 == null) break block4;
            workflowModel3.setWorkflowState(WorkflowModel.WorkflowState.DETECTING);
        }
    }

    protected void onPause() {
        super.onPause();
        this.currentWorkflowState = WorkflowModel.WorkflowState.NOT_STARTED;
        this.stopCameraPreview();
    }

    protected void onDestroy() {
        super.onDestroy();
        CameraSource cameraSource = this.cameraSource;
        if (cameraSource != null) {
            cameraSource.release();
        }
        this.cameraSource = null;
    }

    private final void startCameraPreview() {
        WorkflowModel workflowModel = this.workflowModel;
        if (workflowModel == null) {
            return;
        }
        WorkflowModel workflowModel2 = workflowModel;
        CameraSource cameraSource = this.cameraSource;
        if (cameraSource == null) {
            return;
        }
        CameraSource cameraSource2 = cameraSource;
        if (!workflowModel2.isCameraLive()) {
            try {
                workflowModel2.markCameraLive();
                CameraSourcePreview cameraSourcePreview = this.preview;
                if (cameraSourcePreview != null) {
                    cameraSourcePreview.start(cameraSource2);
                }
            }
            catch (IOException e) {
                cameraSource2.release();
                this.cameraSource = null;
                Utils.INSTANCE.postError(TAG, "Failed to start camera preview!", e);
            }
        }
    }

    private final void stopCameraPreview() {
        block2: {
            WorkflowModel workflowModel = this.workflowModel;
            if (workflowModel == null) {
                return;
            }
            WorkflowModel workflowModel2 = workflowModel;
            if (!workflowModel2.isCameraLive()) break block2;
            workflowModel2.markCameraFrozen();
            CameraSourcePreview cameraSourcePreview = this.preview;
            if (cameraSourcePreview != null) {
                cameraSourcePreview.stop();
            }
        }
    }

    private final void setUpWorkflowModel() {
        block1: {
            WorkflowModel workflowModel = this.workflowModel = (WorkflowModel)ViewModelProviders.of((FragmentActivity)((FragmentActivity)this)).get(WorkflowModel.class);
            if (workflowModel == null) {
                Intrinsics.throwNpe();
            }
            workflowModel.getWorkflowState().observe((LifecycleOwner)this, (Observer)new Observer<WorkflowModel.WorkflowState>(this){
                final /* synthetic */ LiveBarcodeScanningActivity this$0;

                /*
                 * Unable to fully structure code
                 */
                public final void onChanged(WorkflowModel.WorkflowState workflowState) {
                    block12: {
                        if (workflowState == null || LiveBarcodeScanningActivity.access$getCurrentWorkflowState$p(this.this$0) == workflowState) {
                            return;
                        }
                        LiveBarcodeScanningActivity.access$setCurrentWorkflowState$p(this.this$0, workflowState);
                        v0 = new StringBuilder().append("Current workflow state: ");
                        v1 = LiveBarcodeScanningActivity.access$getCurrentWorkflowState$p(this.this$0);
                        if (v1 == null) {
                            Intrinsics.throwNpe();
                        }
                        Log.d((String)"LiveBarcodeActivity", (String)v0.append(v1.name()).toString());
                        v2 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                        wasPromptChipGone = v2 != null && v2.getVisibility() == 8;
                        switch (LiveBarcodeScanningActivity$WhenMappings.$EnumSwitchMapping$0[workflowState.ordinal()]) {
                            case 1: {
                                v3 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                                if (v3 != null) {
                                    v3.setVisibility(0);
                                }
                                v4 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                                if (v4 != null) {
                                    v4.setText(R.string.prompt_point_at_a_barcode);
                                }
                                LiveBarcodeScanningActivity.access$startCameraPreview(this.this$0);
                                break;
                            }
                            case 2: {
                                v5 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                                if (v5 != null) {
                                    v5.setVisibility(8);
                                }
                                LiveBarcodeScanningActivity.access$stopCameraPreview(this.this$0);
                                break;
                            }
                            default: {
                                v6 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                                if (v6 == null) break;
                                v6.setVisibility(8);
                                break;
                            }
                        }
                        if (!wasPromptChipGone) ** GOTO lbl-1000
                        v7 = LiveBarcodeScanningActivity.access$getPromptChip$p(this.this$0);
                        if (v7 == null) ** GOTO lbl-1000
                        if (v7.getVisibility() == 0) {
                            v8 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v8 = false;
                        }
                        shouldPlayPromptChipEnteringAnimation = v8;
                        v9 = LiveBarcodeScanningActivity.access$getPromptChipAnimator$p(this.this$0);
                        if (v9 == null) break block12;
                        var4_4 = v9;
                        var5_5 = false;
                        var6_6 = false;
                        it = var4_4;
                        $i$a$-let-LiveBarcodeScanningActivity$setUpWorkflowModel$1$1 = false;
                        if (shouldPlayPromptChipEnteringAnimation && !it.isRunning()) {
                            it.start();
                        }
                    }
                }
                {
                    this.this$0 = liveBarcodeScanningActivity;
                }
            });
            MutableLiveData<FirebaseVisionBarcode> mutableLiveData = this.workflowModel;
            if (mutableLiveData == null || (mutableLiveData = mutableLiveData.getDetectedBarcode()) == null) break block1;
            mutableLiveData.observe((LifecycleOwner)this, (Observer)new Observer<FirebaseVisionBarcode>(this){
                final /* synthetic */ LiveBarcodeScanningActivity this$0;

                public final void onChanged(FirebaseVisionBarcode barcode) {
                    if (barcode != null) {
                        EventBus eventBus = EventBus.getDefault();
                        BarcodeType barcodeType = BarcodeType.Companion.fromVisionBarcode(barcode.getFormat());
                        String string2 = barcode.getDisplayValue();
                        if (string2 == null) {
                            string2 = "";
                        }
                        eventBus.postSticky((Object)new BarcodeScannedEvent(new BarcodeScannerResult(barcodeType, string2)));
                        this.this$0.finish();
                    }
                }
                {
                    this.this$0 = liveBarcodeScanningActivity;
                }
            });
        }
    }

    public static final /* synthetic */ WorkflowModel.WorkflowState access$getCurrentWorkflowState$p(LiveBarcodeScanningActivity $this) {
        return $this.currentWorkflowState;
    }

    public static final /* synthetic */ void access$setCurrentWorkflowState$p(LiveBarcodeScanningActivity $this, WorkflowModel.WorkflowState workflowState) {
        $this.currentWorkflowState = workflowState;
    }

    public static final /* synthetic */ Chip access$getPromptChip$p(LiveBarcodeScanningActivity $this) {
        return $this.promptChip;
    }

    public static final /* synthetic */ void access$setPromptChip$p(LiveBarcodeScanningActivity $this, Chip chip) {
        $this.promptChip = chip;
    }

    public static final /* synthetic */ void access$startCameraPreview(LiveBarcodeScanningActivity $this) {
        $this.startCameraPreview();
    }

    public static final /* synthetic */ void access$stopCameraPreview(LiveBarcodeScanningActivity $this) {
        $this.stopCameraPreview();
    }

    public static final /* synthetic */ AnimatorSet access$getPromptChipAnimator$p(LiveBarcodeScanningActivity $this) {
        return $this.promptChipAnimator;
    }

    public static final /* synthetic */ void access$setPromptChipAnimator$p(LiveBarcodeScanningActivity $this, AnimatorSet animatorSet) {
        $this.promptChipAnimator = animatorSet;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/salesforce/barcodescannerplugin/LiveBarcodeScanningActivity$Companion;", "", "()V", "OPTIONS_VALUE", "", "TAG", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

