/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin.barcodedetection;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.core.content.ContextCompat;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.barcodedetection.BarcodeGraphicBase;
import com.salesforce.barcodescannerplugin.camera.CameraReticleAnimator;
import com.salesforce.barcodescannerplugin.camera.GraphicOverlay;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/salesforce/barcodescannerplugin/barcodedetection/BarcodeReticleGraphic;", "Lcom/salesforce/barcodescannerplugin/barcodedetection/BarcodeGraphicBase;", "overlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "animator", "Lcom/salesforce/barcodescannerplugin/camera/CameraReticleAnimator;", "(Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;Lcom/salesforce/barcodescannerplugin/camera/CameraReticleAnimator;)V", "rippleAlpha", "", "ripplePaint", "Landroid/graphics/Paint;", "rippleSizeOffset", "rippleStrokeWidth", "draw", "", "canvas", "Landroid/graphics/Canvas;", "barcodescanner_release"})
public final class BarcodeReticleGraphic
extends BarcodeGraphicBase {
    private final Paint ripplePaint;
    private final int rippleSizeOffset;
    private final int rippleStrokeWidth;
    private final int rippleAlpha;
    private final CameraReticleAnimator animator;

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        this.ripplePaint.setAlpha((int)((float)this.rippleAlpha * this.animator.getRippleAlphaScale()));
        this.ripplePaint.setStrokeWidth((float)this.rippleStrokeWidth * this.animator.getRippleStrokeWidthScale());
        float offset = (float)this.rippleSizeOffset * this.animator.getRippleSizeScale();
        RectF rippleRect = new RectF(this.getBoxRect().left - offset, this.getBoxRect().top - offset, this.getBoxRect().right + offset, this.getBoxRect().bottom + offset);
        canvas.drawRoundRect(rippleRect, this.getBoxCornerRadius(), this.getBoxCornerRadius(), this.ripplePaint);
    }

    public BarcodeReticleGraphic(@NotNull GraphicOverlay overlay, @NotNull CameraReticleAnimator animator2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overlay), (String)"overlay");
        Intrinsics.checkParameterIsNotNull((Object)animator2, (String)"animator");
        super(overlay);
        this.animator = animator2;
        Resources resources = overlay.getResources();
        this.ripplePaint = new Paint();
        this.ripplePaint.setStyle(Paint.Style.STROKE);
        this.ripplePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.reticle_ripple));
        this.rippleSizeOffset = resources.getDimensionPixelOffset(R.dimen.barcode_reticle_ripple_size_offset);
        this.rippleStrokeWidth = resources.getDimensionPixelOffset(R.dimen.barcode_reticle_ripple_stroke_width);
        this.rippleAlpha = this.ripplePaint.getAlpha();
    }
}

