/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin.barcodedetection;

import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import androidx.annotation.MainThread;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.salesforce.barcodescannerplugin.Utils;
import com.salesforce.barcodescannerplugin.barcodedetection.BarcodeReticleGraphic;
import com.salesforce.barcodescannerplugin.camera.CameraReticleAnimator;
import com.salesforce.barcodescannerplugin.camera.FrameProcessorBase;
import com.salesforce.barcodescannerplugin.camera.GraphicOverlay;
import com.salesforce.barcodescannerplugin.camera.WorkflowModel;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0014J&\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0015J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/salesforce/barcodescannerplugin/barcodedetection/BarcodeProcessor;", "Lcom/salesforce/barcodescannerplugin/camera/FrameProcessorBase;", "", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "graphicOverlay", "Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;", "workflowModel", "Lcom/salesforce/barcodescannerplugin/camera/WorkflowModel;", "options", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetectorOptions;", "(Lcom/salesforce/barcodescannerplugin/camera/GraphicOverlay;Lcom/salesforce/barcodescannerplugin/camera/WorkflowModel;Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetectorOptions;)V", "cameraReticleAnimator", "Lcom/salesforce/barcodescannerplugin/camera/CameraReticleAnimator;", "detector", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcodeDetector;", "detectInImage", "Lcom/google/android/gms/tasks/Task;", "image", "Lcom/google/firebase/ml/vision/common/FirebaseVisionImage;", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "results", "stop", "Companion", "barcodescanner_release"})
public final class BarcodeProcessor
extends FrameProcessorBase<List<? extends FirebaseVisionBarcode>> {
    private final FirebaseVisionBarcodeDetector detector;
    private final CameraReticleAnimator cameraReticleAnimator;
    private final WorkflowModel workflowModel;
    private static final String TAG = "BarcodeProcessor";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Task<List<FirebaseVisionBarcode>> detectInImage(@NotNull FirebaseVisionImage image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Task task = this.detector.detectInImage(image);
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"detector.detectInImage(image)");
        return task;
    }

    @Override
    @MainThread
    protected void onSuccess(@NotNull FirebaseVisionImage image, @NotNull List<? extends FirebaseVisionBarcode> results, @NotNull GraphicOverlay graphicOverlay) {
        Object v1;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
            if (!this.workflowModel.isCameraLive()) {
                return;
            }
            Log.d((String)TAG, (String)("Barcode result size: " + results.size()));
            Iterable $this$firstOrNull$iv = results;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                FirebaseVisionBarcode barcode = (FirebaseVisionBarcode)element$iv;
                boolean bl2 = false;
                if (barcode.getBoundingBox() == null) {
                    bl = false;
                } else {
                    Rect boundingBox;
                    Intrinsics.checkExpressionValueIsNotNull((Object)boundingBox, (String)"barcode.boundingBox ?: return@firstOrNull false");
                    RectF box = graphicOverlay.translateRect(boundingBox);
                    bl = box.contains((float)graphicOverlay.getWidth() / 2.0f, (float)graphicOverlay.getHeight() / 2.0f);
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        FirebaseVisionBarcode barcodeInCenter = v1;
        graphicOverlay.clear();
        if (barcodeInCenter == null) {
            this.cameraReticleAnimator.start();
            graphicOverlay.add(new BarcodeReticleGraphic(graphicOverlay, this.cameraReticleAnimator));
            this.workflowModel.setWorkflowState(WorkflowModel.WorkflowState.DETECTING);
        } else {
            this.cameraReticleAnimator.cancel();
            this.workflowModel.setWorkflowState(WorkflowModel.WorkflowState.DETECTED);
            this.workflowModel.getDetectedBarcode().setValue((Object)barcodeInCenter);
        }
        graphicOverlay.invalidate();
    }

    @Override
    protected void onFailure(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Utils.INSTANCE.postError(TAG, "Barcode detection failed!", e);
    }

    @Override
    public void stop() {
        try {
            this.detector.close();
        }
        catch (IOException e) {
            Utils.INSTANCE.postError(TAG, "Failed to close barcode detector!", e);
        }
    }

    public BarcodeProcessor(@NotNull GraphicOverlay graphicOverlay, @NotNull WorkflowModel workflowModel, @Nullable FirebaseVisionBarcodeDetectorOptions options) {
        FirebaseVisionBarcodeDetector firebaseVisionBarcodeDetector;
        Intrinsics.checkParameterIsNotNull((Object)((Object)graphicOverlay), (String)"graphicOverlay");
        Intrinsics.checkParameterIsNotNull((Object)((Object)workflowModel), (String)"workflowModel");
        this.workflowModel = workflowModel;
        if (options == null) {
            FirebaseVision firebaseVision = FirebaseVision.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVision, (String)"FirebaseVision.getInstance()");
            firebaseVisionBarcodeDetector = firebaseVision.getVisionBarcodeDetector();
        } else {
            firebaseVisionBarcodeDetector = FirebaseVision.getInstance().getVisionBarcodeDetector(options);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseVisionBarcodeDetector, (String)"if (options == null) Fir\u2026        options\n        )");
        this.detector = firebaseVisionBarcodeDetector;
        this.cameraReticleAnimator = new CameraReticleAnimator(graphicOverlay);
    }

    public /* synthetic */ BarcodeProcessor(GraphicOverlay graphicOverlay, WorkflowModel workflowModel, FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firebaseVisionBarcodeDetectorOptions = null;
        }
        this(graphicOverlay, workflowModel, firebaseVisionBarcodeDetectorOptions);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/salesforce/barcodescannerplugin/barcodedetection/BarcodeProcessor$Companion;", "", "()V", "TAG", "", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

