/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.hardware.Camera;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.salesforce.barcodescannerplugin.barcodedetection.BarcodeErrorEvent;
import com.salesforce.barcodescannerplugin.camera.CameraSizePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/salesforce/barcodescannerplugin/Utils;", "", "()V", "ASPECT_RATIO_TOLERANCE", "", "REQUIRED_PERMISSION", "", "TAG", "generateValidPreviewSizeList", "", "Lcom/salesforce/barcodescannerplugin/camera/CameraSizePair;", "camera", "Landroid/hardware/Camera;", "isPortraitMode", "", "context", "Landroid/content/Context;", "postError", "", "sourceClass", "errorMessage", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "verifyPermissionGranted", "activity", "Landroid/app/Activity;", "barcodescanner_release"})
public final class Utils {
    public static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private static final String REQUIRED_PERMISSION = "android.permission.CAMERA";
    private static final String TAG = "Utils";
    public static final Utils INSTANCE;

    public final void verifyPermissionGranted(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (ContextCompat.checkSelfPermission((Context)((Context)activity), (String)REQUIRED_PERMISSION) != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{REQUIRED_PERMISSION}, (int)0);
        }
    }

    public final boolean isPortraitMode(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1;
    }

    @NotNull
    public final List<CameraSizePair> generateValidPreviewSizeList(@NotNull Camera camera) {
        Camera.Parameters parameters;
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        Camera.Parameters parameters2 = parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
        List supportedPreviewSizes = parameters2.getSupportedPreviewSizes();
        List supportedPictureSizes = parameters.getSupportedPictureSizes();
        ArrayList<CameraSizePair> validPreviewSizes = new ArrayList<CameraSizePair>();
        block0: for (Camera.Size previewSize : supportedPreviewSizes) {
            float previewAspectRatio = (float)previewSize.width / (float)previewSize.height;
            for (Camera.Size pictureSize : supportedPictureSizes) {
                float pictureAspectRatio = (float)pictureSize.width / (float)pictureSize.height;
                float f = previewAspectRatio - pictureAspectRatio;
                boolean bl = false;
                if (!(Math.abs(f) < 0.01f)) continue;
                Camera.Size size = previewSize;
                Intrinsics.checkExpressionValueIsNotNull((Object)size, (String)"previewSize");
                validPreviewSizes.add(new CameraSizePair(size, pictureSize));
                continue block0;
            }
        }
        if (validPreviewSizes.isEmpty()) {
            Log.w((String)TAG, (String)"No preview sizes have a corresponding same-aspect-ratio picture size.");
            Iterator iterator = supportedPreviewSizes.iterator();
            while (iterator.hasNext()) {
                Camera.Size previewSize;
                Camera.Size size = previewSize = (Camera.Size)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)size, (String)"previewSize");
                validPreviewSizes.add(new CameraSizePair(size, null));
            }
        }
        return validPreviewSizes;
    }

    public final void postError(@NotNull String sourceClass, @NotNull String errorMessage, @NotNull Exception error) {
        Intrinsics.checkParameterIsNotNull((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Log.e((String)sourceClass, (String)errorMessage, (Throwable)error);
        EventBus.getDefault().postSticky((Object)new BarcodeErrorEvent(errorMessage + ": " + error.getMessage()));
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

